/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SubPlan {
    private final PlanFragment fragment;
    private final List<SubPlan> children;

    public SubPlan(PlanFragment fragment, List<SubPlan> children) {
        Preconditions.checkNotNull((Object)fragment, (Object)"fragment is null");
        Preconditions.checkNotNull(children, (Object)"children is null");
        this.fragment = fragment;
        this.children = ImmutableList.copyOf(children);
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public List<SubPlan> getChildren() {
        return this.children;
    }

    public List<PlanFragment> getAllFragments() {
        ImmutableList.Builder fragments = ImmutableList.builder();
        fragments.add((Object)this.getFragment());
        for (SubPlan child : this.getChildren()) {
            fragments.addAll(child.getAllFragments());
        }
        return fragments.build();
    }

    public void sanityCheck() {
        Multiset exchangeIds = (Multiset)this.fragment.getRemoteSourceNodes().stream().map(RemoteSourceNode::getSourceFragmentIds).flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableMultiset());
        Multiset childrenIds = (Multiset)this.children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableCollectors.toImmutableMultiset());
        Preconditions.checkState((boolean)exchangeIds.equals((Object)childrenIds), (String)"Subplan exchange ids don't match child fragment ids (%s vs %s)", (Object[])new Object[]{exchangeIds, childrenIds});
        for (SubPlan child : this.children) {
            child.sanityCheck();
        }
    }
}

