/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProjectionPushDown
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(idAllocator, symbolAllocator), plan);
    }

    private static Expression translateExpression(Expression inputExpression, final Map<Symbol, QualifiedNameReference> symbolMapping) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)symbolMapping.get(Symbol.fromQualifiedName(node.getName()));
                Preconditions.checkState((qualifiedNameReference != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object[])new Object[]{node.getName()});
                return qualifiedNameReference;
            }
        }, (Expression)inputExpression);
    }

    private static class Rewriter
    extends PlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;

        public Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        }

        @Override
        public PlanNode visitProject(ProjectNode node, PlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            if (!(source instanceof UnionNode)) {
                return context.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
            }
            UnionNode unionNode = (UnionNode)source;
            List<Symbol> outputLayout = node.getOutputSymbols();
            ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
            ImmutableList.Builder outputSources = ImmutableList.builder();
            for (int i = 0; i < unionNode.getSources().size(); ++i) {
                Map<Symbol, QualifiedNameReference> outputToInput = unionNode.sourceSymbolMap(i);
                ImmutableMap.Builder assignments = ImmutableMap.builder();
                HashMap<Symbol, Symbol> projectSymbolMapping = new HashMap<Symbol, Symbol>();
                for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                    Expression translatedExpression = ProjectionPushDown.translateExpression(entry.getValue(), outputToInput);
                    Type type = this.symbolAllocator.getTypes().get(entry.getKey());
                    Symbol symbol2 = this.symbolAllocator.newSymbol(translatedExpression, type);
                    assignments.put((Object)symbol2, (Object)translatedExpression);
                    projectSymbolMapping.put(entry.getKey(), symbol2);
                }
                outputSources.add((Object)new ProjectNode(this.idAllocator.getNextId(), unionNode.getSources().get(i), (Map<Symbol, Expression>)assignments.build()));
                outputLayout.forEach(symbol -> mappings.put(symbol, projectSymbolMapping.get(symbol)));
            }
            return new UnionNode(node.getId(), (List<PlanNode>)outputSources.build(), (ListMultimap<Symbol, Symbol>)mappings.build());
        }
    }
}

