/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class InputExtractor {
    private final Metadata metadata;
    private final Session session;

    public InputExtractor(Metadata metadata, Session session) {
        this.metadata = metadata;
        this.session = session;
    }

    public List<Input> extract(PlanNode root) {
        Visitor visitor = new Visitor();
        root.accept(visitor, null);
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        for (Map.Entry<TableEntry, Set<Column>> entry : visitor.getInputs().entrySet()) {
            Input input = new Input(entry.getKey().getConnectorId(), entry.getKey().getSchema(), entry.getKey().getTable(), (List<Column>)ImmutableList.copyOf((Collection)entry.getValue()));
            inputBuilder.add((Object)input);
        }
        return inputBuilder.build();
    }

    private static Column createColumnEntry(ColumnMetadata columnMetadata) {
        return new Column(columnMetadata.getName(), columnMetadata.getType().toString(), Optional.empty());
    }

    private static TableEntry createTableEntry(TableMetadata table) {
        SchemaTableName schemaTable = table.getTable();
        return new TableEntry(table.getConnectorId(), schemaTable.getSchemaName(), schemaTable.getTableName());
    }

    private static final class TableEntry {
        private final String connectorId;
        private final String schema;
        private final String table;

        private TableEntry(String connectorId, String schema, String table) {
            this.connectorId = connectorId;
            this.schema = schema;
            this.table = table;
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTable() {
            return this.table;
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.schema, this.table);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TableEntry other = (TableEntry)obj;
            return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.schema, other.schema) && Objects.equals(this.table, other.table);
        }
    }

    private class Visitor
    extends PlanVisitor<Void, Void> {
        private final Map<TableEntry, Set<Column>> inputs = new HashMap<TableEntry, Set<Column>>();

        private Visitor() {
        }

        public Map<TableEntry, Set<Column>> getInputs() {
            return this.inputs;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            TableHandle tableHandle = node.getTable();
            Optional<ColumnHandle> sampleWeightColumn = InputExtractor.this.metadata.getSampleWeightColumnHandle(InputExtractor.this.session, tableHandle);
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                if (columnHandle.equals(sampleWeightColumn.orElse(null))) continue;
                columns.add(InputExtractor.createColumnEntry(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            this.inputs.put(InputExtractor.createTableEntry(InputExtractor.this.metadata.getTableMetadata(InputExtractor.this.session, tableHandle)), columns);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            TableHandle tableHandle = node.getTableHandle();
            Optional<ColumnHandle> sampleWeightColumn = InputExtractor.this.metadata.getSampleWeightColumnHandle(InputExtractor.this.session, tableHandle);
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                if (columnHandle.equals(sampleWeightColumn.orElse(null))) continue;
                columns.add(InputExtractor.createColumnEntry(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            this.inputs.put(InputExtractor.createTableEntry(InputExtractor.this.metadata.getTableMetadata(InputExtractor.this.session, tableHandle)), columns);
            return null;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }
    }
}

