/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Marker;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Primitives;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;

public final class DomainTranslator {
    private static final String DATE_LITERAL = FunctionRegistry.getMagicLiteralFunctionSignature((Type)DateType.DATE).getName();
    private static final String TIMESTAMP_LITERAL = FunctionRegistry.getMagicLiteralFunctionSignature((Type)TimestampType.TIMESTAMP).getName();

    private DomainTranslator() {
    }

    public static Expression toPredicate(TupleDomain<Symbol> tupleDomain, Map<Symbol, Type> symbolTypes) {
        if (tupleDomain.isNone()) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        ImmutableList.Builder conjunctBuilder = ImmutableList.builder();
        for (Map.Entry entry : tupleDomain.getDomains().entrySet()) {
            Symbol symbol = (Symbol)entry.getKey();
            QualifiedNameReference reference = new QualifiedNameReference(symbol.toQualifiedName());
            Type type = symbolTypes.get(symbol);
            conjunctBuilder.add((Object)DomainTranslator.toPredicate((Domain)entry.getValue(), reference, type));
        }
        return ExpressionUtils.combineConjuncts((Iterable<Expression>)conjunctBuilder.build());
    }

    private static Expression toPredicate(Domain domain, QualifiedNameReference reference, Type type) {
        if (domain.getRanges().isNone()) {
            return domain.isNullAllowed() ? new IsNullPredicate((Expression)reference) : BooleanLiteral.FALSE_LITERAL;
        }
        if (domain.getRanges().isAll()) {
            return domain.isNullAllowed() ? BooleanLiteral.TRUE_LITERAL : new NotExpression((Expression)new IsNullPredicate((Expression)reference));
        }
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        ArrayList<Expression> singleValues = new ArrayList<Expression>();
        for (Range range : domain.getRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(LiteralInterpreter.toExpression(range.getLow().getValue(), type));
                continue;
            }
            if (DomainTranslator.isBetween(range)) {
                disjuncts.add((Expression)new BetweenPredicate((Expression)reference, LiteralInterpreter.toExpression(range.getLow().getValue(), type), LiteralInterpreter.toExpression(range.getHigh().getValue(), type)));
                continue;
            }
            ArrayList<Expression> rangeConjuncts = new ArrayList<Expression>();
            if (!range.getLow().isLowerUnbounded()) {
                switch (range.getLow().getBound()) {
                    case ABOVE: {
                        rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN, (Expression)reference, LiteralInterpreter.toExpression(range.getLow().getValue(), type)));
                        break;
                    }
                    case EXACTLY: {
                        rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, (Expression)reference, LiteralInterpreter.toExpression(range.getLow().getValue(), type)));
                        break;
                    }
                    case BELOW: {
                        throw new IllegalStateException("Low Marker should never use BELOW bound: " + range);
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                    }
                }
            }
            if (!range.getHigh().isUpperUnbounded()) {
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalStateException("High Marker should never use ABOVE bound: " + range);
                    }
                    case EXACTLY: {
                        rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, (Expression)reference, LiteralInterpreter.toExpression(range.getHigh().getValue(), type)));
                        break;
                    }
                    case BELOW: {
                        rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.LESS_THAN, (Expression)reference, LiteralInterpreter.toExpression(range.getHigh().getValue(), type)));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                    }
                }
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add(ExpressionUtils.combineConjuncts(rangeConjuncts));
        }
        if (singleValues.size() == 1) {
            disjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add((Expression)new InPredicate((Expression)reference, (Expression)new InListExpression(singleValues)));
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add((Expression)new IsNullPredicate((Expression)reference));
        }
        return ExpressionUtils.combineDisjunctsWithDefault(disjuncts, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    private static boolean isBetween(Range range) {
        return !range.getLow().isLowerUnbounded() && range.getLow().getBound() == Marker.Bound.EXACTLY && !range.getHigh().isUpperUnbounded() && range.getHigh().getBound() == Marker.Bound.EXACTLY;
    }

    public static ExtractionResult fromPredicate(Metadata metadata, Session session, Expression predicate, Map<Symbol, Type> types) {
        return (ExtractionResult)new Visitor(metadata, session, types).process((Node)predicate, false);
    }

    private static boolean isSimpleComparison(ComparisonExpression comparison) {
        return comparison.getLeft() instanceof QualifiedNameReference && comparison.getRight() instanceof Literal || comparison.getLeft() instanceof Literal && comparison.getRight() instanceof QualifiedNameReference;
    }

    private static ComparisonExpression normalizeSimpleComparison(ComparisonExpression comparison) {
        if (comparison.getLeft() instanceof QualifiedNameReference) {
            return comparison;
        }
        if (comparison.getRight() instanceof QualifiedNameReference) {
            return new ComparisonExpression(ExpressionUtils.flipComparison(comparison.getType()), comparison.getRight(), comparison.getLeft());
        }
        throw new IllegalArgumentException("ComparisonExpression not a simple literal comparison: " + comparison);
    }

    private static Expression coerceDoubleToLongComparison(ComparisonExpression comparison) {
        comparison = DomainTranslator.normalizeSimpleComparison(comparison);
        Preconditions.checkArgument((boolean)(comparison.getLeft() instanceof QualifiedNameReference), (Object)"Left must be a QualifiedNameReference");
        Preconditions.checkArgument((boolean)(comparison.getRight() instanceof DoubleLiteral), (Object)"Right must be a DoubleLiteral");
        QualifiedNameReference reference = (QualifiedNameReference)comparison.getLeft();
        Double value = ((DoubleLiteral)comparison.getRight()).getValue();
        switch (comparison.getType()) {
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: {
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.CEILING), (Type)BigintType.BIGINT));
            }
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR), (Type)BigintType.BIGINT));
            }
            case EQUAL: {
                Long equalValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (equalValue.doubleValue() != value.doubleValue()) {
                    return ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)new LongLiteral("0")), new ComparisonExpression(ComparisonExpression.Type.NOT_EQUAL, (Expression)reference, (Expression)new LongLiteral("0"))});
                }
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(equalValue, (Type)BigintType.BIGINT));
            }
            case NOT_EQUAL: {
                Long notEqualValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (notEqualValue.doubleValue() != value.doubleValue()) {
                    return ExpressionUtils.or(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)new LongLiteral("0")), new ComparisonExpression(ComparisonExpression.Type.NOT_EQUAL, (Expression)reference, (Expression)new LongLiteral("0"))});
                }
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(notEqualValue, (Type)BigintType.BIGINT));
            }
            case IS_DISTINCT_FROM: {
                Long distinctValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (distinctValue.doubleValue() != value.doubleValue()) {
                    return BooleanLiteral.TRUE_LITERAL;
                }
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(distinctValue, (Type)BigintType.BIGINT));
            }
        }
        throw new AssertionError((Object)("Unhandled type: " + comparison.getType()));
    }

    private static boolean isSimpleMagicLiteralComparison(ComparisonExpression node) {
        FunctionCall call;
        if (node.getLeft() instanceof QualifiedNameReference && node.getRight() instanceof FunctionCall) {
            call = (FunctionCall)node.getRight();
        } else if (node.getLeft() instanceof FunctionCall && node.getRight() instanceof QualifiedNameReference) {
            call = (FunctionCall)node.getLeft();
        } else {
            return false;
        }
        if (call.getName().getPrefix().isPresent()) {
            return false;
        }
        String name = call.getName().getSuffix();
        return name.equals(DATE_LITERAL) || name.equals(TIMESTAMP_LITERAL);
    }

    private static ComparisonExpression convertMagicLiteralComparison(ComparisonExpression node) {
        Preconditions.checkArgument((boolean)DomainTranslator.isSimpleMagicLiteralComparison(node), (Object)"not a simple magic literal comparison");
        FunctionCall call = (FunctionCall)node.getRight();
        Expression value = (Expression)call.getArguments().get(0);
        return new ComparisonExpression(node.getType(), node.getLeft(), value);
    }

    public static class ExtractionResult {
        private final TupleDomain<Symbol> tupleDomain;
        private final Expression remainingExpression;

        public ExtractionResult(TupleDomain<Symbol> tupleDomain, Expression remainingExpression) {
            this.tupleDomain = (TupleDomain)Preconditions.checkNotNull(tupleDomain, (Object)"tupleDomain is null");
            this.remainingExpression = (Expression)Preconditions.checkNotNull((Object)remainingExpression, (Object)"remainingExpression is null");
        }

        public TupleDomain<Symbol> getTupleDomain() {
            return this.tupleDomain;
        }

        public Expression getRemainingExpression() {
            return this.remainingExpression;
        }
    }

    private static class Visitor
    extends AstVisitor<ExtractionResult, Boolean> {
        private final Metadata metadata;
        private final ConnectorSession session;
        private final Map<Symbol, Type> types;

        private Visitor(Metadata metadata, Session session, Map<Symbol, Type> types) {
            this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
            this.session = ((Session)Preconditions.checkNotNull((Object)session, (Object)"session is null")).toConnectorSession();
            this.types = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(types, (Object)"types is null")));
        }

        private Type checkedTypeLookup(Symbol symbol) {
            Type type = this.types.get(symbol);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Types is missing info for symbol: %s", (Object[])new Object[]{symbol});
            return type;
        }

        private static SortedRangeSet complementIfNecessary(SortedRangeSet range, boolean complement) {
            return complement ? range.complement() : range;
        }

        private static Domain complementIfNecessary(Domain domain, boolean complement) {
            return complement ? domain.complement() : domain;
        }

        private static Expression complementIfNecessary(Expression expression, boolean complement) {
            return complement ? new NotExpression(expression) : expression;
        }

        protected ExtractionResult visitExpression(Expression node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.all(), Visitor.complementIfNecessary(node, (boolean)complement));
        }

        protected ExtractionResult visitLogicalBinaryExpression(LogicalBinaryExpression node, Boolean complement) {
            ExtractionResult leftResult = (ExtractionResult)this.process((Node)node.getLeft(), complement);
            ExtractionResult rightResult = (ExtractionResult)this.process((Node)node.getRight(), complement);
            LogicalBinaryExpression.Type type = complement != false ? Visitor.flipLogicalBinaryType(node.getType()) : node.getType();
            switch (type) {
                case AND: {
                    return new ExtractionResult((TupleDomain<Symbol>)leftResult.getTupleDomain().intersect(rightResult.getTupleDomain()), ExpressionUtils.combineConjuncts(leftResult.getRemainingExpression(), rightResult.getRemainingExpression()));
                }
                case OR: {
                    TupleDomain columnUnionedTupleDomain = TupleDomain.columnWiseUnion(leftResult.getTupleDomain(), rightResult.getTupleDomain(), (TupleDomain[])new TupleDomain[0]);
                    Expression remainingExpression = Visitor.complementIfNecessary((Expression)node, (boolean)complement);
                    if (leftResult.getRemainingExpression().equals((Object)rightResult.getRemainingExpression()) && DeterminismEvaluator.isDeterministic(leftResult.getRemainingExpression())) {
                        boolean oneSideIsSuperSet;
                        boolean matchingSingleSymbolDomains = !leftResult.getTupleDomain().isNone() && !rightResult.getTupleDomain().isNone() && leftResult.getTupleDomain().getDomains().size() == 1 && rightResult.getTupleDomain().getDomains().size() == 1 && leftResult.getTupleDomain().getDomains().keySet().equals(rightResult.getTupleDomain().getDomains().keySet());
                        boolean bl = oneSideIsSuperSet = leftResult.getTupleDomain().contains(rightResult.getTupleDomain()) || rightResult.getTupleDomain().contains(leftResult.getTupleDomain());
                        if (matchingSingleSymbolDomains || oneSideIsSuperSet) {
                            remainingExpression = leftResult.getRemainingExpression();
                        }
                    }
                    return new ExtractionResult((TupleDomain<Symbol>)columnUnionedTupleDomain, remainingExpression);
                }
            }
            throw new AssertionError((Object)("Unknown type: " + node.getType()));
        }

        private static LogicalBinaryExpression.Type flipLogicalBinaryType(LogicalBinaryExpression.Type type) {
            switch (type) {
                case AND: {
                    return LogicalBinaryExpression.Type.OR;
                }
                case OR: {
                    return LogicalBinaryExpression.Type.AND;
                }
            }
            throw new AssertionError((Object)("Unknown type: " + type));
        }

        protected ExtractionResult visitNotExpression(NotExpression node, Boolean complement) {
            return (ExtractionResult)this.process((Node)node.getValue(), complement == false);
        }

        protected ExtractionResult visitComparisonExpression(ComparisonExpression node, Boolean complement) {
            if (DomainTranslator.isSimpleMagicLiteralComparison(node)) {
                node = DomainTranslator.normalizeSimpleComparison(node);
                node = DomainTranslator.convertMagicLiteralComparison(node);
            } else if (DomainTranslator.isSimpleComparison(node)) {
                node = DomainTranslator.normalizeSimpleComparison(node);
            } else {
                return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
            }
            Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)node.getLeft()).getName());
            Type columnType = this.checkedTypeLookup(symbol);
            Object value = LiteralInterpreter.evaluate(this.metadata, this.session, node.getRight());
            if (value instanceof Double && columnType.equals(BigintType.BIGINT)) {
                return (ExtractionResult)this.process((Node)DomainTranslator.coerceDoubleToLongComparison(node), complement);
            }
            if (value instanceof Long && columnType.equals(DoubleType.DOUBLE)) {
                value = ((Long)value).doubleValue();
            }
            Visitor.verifyType(columnType, value);
            return this.createComparisonExtractionResult(node.getType(), symbol, columnType, Visitor.objectToComparable(value), complement);
        }

        private ExtractionResult createComparisonExtractionResult(ComparisonExpression.Type comparisonType, Symbol column, Type columnType, Comparable<?> value, boolean complement) {
            Domain domain;
            if (value == null) {
                switch (comparisonType) {
                    case EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case NOT_EQUAL: {
                        return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
                    }
                    case IS_DISTINCT_FROM: {
                        Domain domain2 = Visitor.complementIfNecessary(Domain.notNull((Class)Primitives.wrap((Class)columnType.getJavaType())), complement);
                        return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain2)), (Expression)BooleanLiteral.TRUE_LITERAL);
                    }
                }
                throw new AssertionError((Object)("Unhandled type: " + comparisonType));
            }
            switch (comparisonType) {
                case EQUAL: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.equal(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case GREATER_THAN: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.greaterThan(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.greaterThanOrEqual(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case LESS_THAN: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.lessThan(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.lessThanOrEqual(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case NOT_EQUAL: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.lessThan(value), (Range[])new Range[]{Range.greaterThan(value)}), complement), (boolean)false);
                    break;
                }
                case IS_DISTINCT_FROM: {
                    domain = Visitor.complementIfNecessary(Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan(value), (Range[])new Range[]{Range.greaterThan(value)}), (boolean)true), complement);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled type: " + comparisonType));
                }
            }
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        private static void verifyType(Type type, Object value) {
            Preconditions.checkState((value == null || Primitives.wrap((Class)type.getJavaType()).isInstance(value) ? 1 : 0) != 0, (String)"Value %s is not of expected type %s", (Object[])new Object[]{value, type});
        }

        private static Comparable<?> objectToComparable(Object value) {
            return (Comparable)value;
        }

        protected ExtractionResult visitInPredicate(InPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference) || !(node.getValueList() instanceof InListExpression)) {
                return (ExtractionResult)super.visitInPredicate(node, (Object)complement);
            }
            InListExpression valueList = (InListExpression)node.getValueList();
            Preconditions.checkState((!valueList.getValues().isEmpty() ? 1 : 0) != 0, (Object)"InListExpression should never be empty");
            ImmutableList.Builder disjuncts = ImmutableList.builder();
            for (Expression expression : valueList.getValues()) {
                disjuncts.add((Object)new ComparisonExpression(ComparisonExpression.Type.EQUAL, node.getValue(), expression));
            }
            return (ExtractionResult)this.process((Node)ExpressionUtils.or((Iterable<Expression>)disjuncts.build()), complement);
        }

        protected ExtractionResult visitBetweenPredicate(BetweenPredicate node, Boolean complement) {
            return (ExtractionResult)this.process((Node)ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin()), new ComparisonExpression(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax())}), complement);
        }

        protected ExtractionResult visitIsNullPredicate(IsNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference)) {
                return (ExtractionResult)super.visitIsNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)node.getValue()).getName());
            Type columnType = this.checkedTypeLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.onlyNull((Class)Primitives.wrap((Class)columnType.getJavaType())), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitIsNotNullPredicate(IsNotNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference)) {
                return (ExtractionResult)super.visitIsNotNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)node.getValue()).getName());
            Type columnType = this.checkedTypeLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.notNull((Class)Primitives.wrap((Class)columnType.getJavaType())), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitBooleanLiteral(BooleanLiteral node, Boolean complement) {
            boolean value = complement.booleanValue() ? !node.getValue() : node.getValue();
            return new ExtractionResult((TupleDomain<Symbol>)(value ? TupleDomain.all() : TupleDomain.none()), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitNullLiteral(NullLiteral node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }
    }
}

