/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.reflect.Method;
import java.util.List;

public class SqlTypeByteCodeExpression
extends ByteCodeExpression {
    private final Type type;
    private final Binding binding;
    private final Method bootstrapMethod;

    public static SqlTypeByteCodeExpression constantType(CallSiteBinder callSiteBinder, Type type) {
        Preconditions.checkNotNull((Object)callSiteBinder, (Object)"callSiteBinder is null");
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Binding binding = callSiteBinder.bind(type, Type.class);
        return new SqlTypeByteCodeExpression(type, binding, Bootstrap.BOOTSTRAP_METHOD);
    }

    private SqlTypeByteCodeExpression(Type type, Binding binding, Method bootstrapMethod) {
        super(ParameterizedType.type(Type.class));
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.binding = (Binding)Preconditions.checkNotNull((Object)binding, (Object)"binding is null");
        this.bootstrapMethod = (Method)Preconditions.checkNotNull((Object)bootstrapMethod, (Object)"bootstrapMethod is null");
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return InvokeInstruction.invokeDynamic(this.type.getTypeSignature().toString().replaceAll("\\W+", "_"), this.binding.getType(), this.bootstrapMethod, this.binding.getBindingId());
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    protected String formatOneLine() {
        return this.type.getTypeSignature().toString();
    }

    public ByteCodeExpression getValue(ByteCodeExpression block, ByteCodeExpression position) {
        Class fromJavaElementType = this.type.getJavaType();
        if (fromJavaElementType == Boolean.TYPE) {
            return this.invoke("getBoolean", Boolean.TYPE, block, position);
        }
        if (fromJavaElementType == Long.TYPE) {
            return this.invoke("getLong", Long.TYPE, block, position);
        }
        if (fromJavaElementType == Double.TYPE) {
            return this.invoke("getDouble", Double.TYPE, block, position);
        }
        if (fromJavaElementType == Slice.class) {
            return this.invoke("getSlice", Slice.class, block, position);
        }
        return this.invoke("getObject", Object.class, block, position).cast(fromJavaElementType);
    }

    public ByteCodeExpression writeValue(ByteCodeExpression blockBuilder, ByteCodeExpression value) {
        Class fromJavaElementType = this.type.getJavaType();
        if (fromJavaElementType == Boolean.TYPE) {
            return this.invoke("writeBoolean", Void.TYPE, blockBuilder, value);
        }
        if (fromJavaElementType == Long.TYPE) {
            return this.invoke("writeLong", Void.TYPE, blockBuilder, value);
        }
        if (fromJavaElementType == Double.TYPE) {
            return this.invoke("writeDouble", Void.TYPE, blockBuilder, value);
        }
        if (fromJavaElementType == Slice.class) {
            return this.invoke("writeSlice", Void.TYPE, blockBuilder, value);
        }
        return this.invoke("writeObject", Void.TYPE, blockBuilder, value.cast(Object.class));
    }
}

