/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class InvokeFunctionByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeNode invocation;
    private final String oneLineDescription;

    public static ByteCodeExpression invokeFunction(Scope scope, CallSiteBinder callSiteBinder, FunctionInfo functionInfo, ByteCodeExpression ... parameters) {
        return InvokeFunctionByteCodeExpression.invokeFunction(scope, callSiteBinder, functionInfo, (List<ByteCodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static ByteCodeExpression invokeFunction(Scope scope, CallSiteBinder callSiteBinder, FunctionInfo functionInfo, List<ByteCodeExpression> parameters) {
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(functionInfo, "functionInfo is null");
        Binding binding = callSiteBinder.bind(functionInfo.getMethodHandle());
        return new InvokeFunctionByteCodeExpression(scope, binding, functionInfo, parameters);
    }

    private InvokeFunctionByteCodeExpression(Scope scope, Binding binding, FunctionInfo functionInfo, List<ByteCodeExpression> parameters) {
        super(ParameterizedType.type(functionInfo.getMethodHandle().type().returnType()));
        this.invocation = ByteCodeUtils.generateInvocation(scope, functionInfo, (List)parameters.stream().map(ByteCodeNode.class::cast).collect(ImmutableCollectors.toImmutableList()), binding);
        this.oneLineDescription = functionInfo.getSignature().getName() + "(" + Joiner.on((String)", ").join(parameters) + ")";
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return this.invocation;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    protected String formatOneLine() {
        return this.oneLineDescription;
    }
}

