/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import java.util.List;

public class IfCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0);
        Variable wasNull = context.wasNull();
        Block condition = new Block().append(context.generate(arguments.get(0))).comment("... and condition value was not null").append(wasNull).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE).invokeStatic(CompilerOperations.class, "and", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE).append(wasNull.set(ByteCodeExpressions.constantFalse()));
        return new IfStatement().condition(condition).ifTrue(context.generate(arguments.get(1))).ifFalse(context.generate(arguments.get(2)));
    }
}

