/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.CursorProcessorCompiler;
import com.facebook.presto.sql.gen.PageProcessorCompiler;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class ExpressionCompiler {
    private final Metadata metadata;
    private final LoadingCache<CacheKey, PageProcessor> pageProcessors = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, PageProcessor>(){

        public PageProcessor load(CacheKey key) throws Exception {
            return (PageProcessor)ExpressionCompiler.this.compileAndInstantiate(key.getFilter(), key.getProjections(), new PageProcessorCompiler(ExpressionCompiler.this.metadata), PageProcessor.class);
        }
    });
    private final LoadingCache<CacheKey, CursorProcessor> cursorProcessors = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, CursorProcessor>(){

        public CursorProcessor load(CacheKey key) throws Exception {
            return (CursorProcessor)ExpressionCompiler.this.compileAndInstantiate(key.getFilter(), key.getProjections(), new CursorProcessorCompiler(ExpressionCompiler.this.metadata), CursorProcessor.class);
        }
    });

    @Inject
    public ExpressionCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Managed
    public long getCacheSize() {
        return this.pageProcessors.size();
    }

    public CursorProcessor compileCursorProcessor(RowExpression filter, List<RowExpression> projections, Object uniqueKey) {
        return (CursorProcessor)this.cursorProcessors.getUnchecked((Object)new CacheKey(filter, projections, uniqueKey));
    }

    public PageProcessor compilePageProcessor(RowExpression filter, List<RowExpression> projections) {
        return (PageProcessor)this.pageProcessors.getUnchecked((Object)new CacheKey(filter, projections, null));
    }

    private <T> T compileAndInstantiate(RowExpression filter, List<RowExpression> projections, BodyCompiler<T> bodyCompiler, Class<? extends T> superType) {
        Class<T> clazz = this.compileProcessor(filter, projections, bodyCompiler, superType);
        try {
            return clazz.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private <T> Class<? extends T> compileProcessor(RowExpression filter, List<RowExpression> projections, BodyCompiler<T> bodyCompiler, Class<? extends T> superType) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(superType.getSimpleName()), ParameterizedType.type(Object.class), ParameterizedType.type(superType));
        classDefinition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        bodyCompiler.generateMethods(classDefinition, callSiteBinder, filter, projections);
        ExpressionCompiler.generateToString(classDefinition, callSiteBinder, MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).add("projections", projections).toString());
        return CompilerUtils.defineClass(classDefinition, superType, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private static void generateToString(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String string) {
        classDefinition.declareMethod(Access.a(Access.PUBLIC), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append(ByteCodeUtils.invoke(callSiteBinder.bind(string, String.class), "toString")).retObject();
    }

    private static final class CacheKey {
        private final RowExpression filter;
        private final List<RowExpression> projections;
        private final Object uniqueKey;

        private CacheKey(RowExpression filter, List<RowExpression> projections, Object uniqueKey) {
            this.filter = filter;
            this.uniqueKey = uniqueKey;
            this.projections = ImmutableList.copyOf(projections);
        }

        private RowExpression getFilter() {
            return this.filter;
        }

        private List<RowExpression> getProjections() {
            return this.projections;
        }

        public int hashCode() {
            return Objects.hash(this.filter, this.projections, this.uniqueKey);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equals(this.filter, other.filter) && Objects.equals(this.projections, other.projections) && Objects.equals(this.uniqueKey, other.uniqueKey);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).add("projections", this.projections).add("uniqueKey", this.uniqueKey).toString();
        }
    }
}

