/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class CoalesceCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        ArrayList<ByteCodeNode> operands = new ArrayList<ByteCodeNode>();
        for (RowExpression expression : arguments) {
            operands.add(generatorContext.generate(expression));
        }
        Variable wasNull = generatorContext.wasNull();
        ByteCodeNode nullValue = new Block().append(wasNull.set(ByteCodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        for (ByteCodeNode operand : Lists.reverse(operands)) {
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition().append(operand).append(wasNull);
            ifStatement.ifTrue().pop(returnType.getJavaType()).append(wasNull.set(ByteCodeExpressions.constantFalse())).append(nullValue);
            nullValue = ifStatement;
        }
        return nullValue;
    }
}

