/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class CastCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        RowExpression argument = arguments.get(0);
        if (argument.getType().equals((Object)UnknownType.UNKNOWN)) {
            return new Block().append(generatorContext.wasNull().set(ByteCodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        }
        FunctionInfo function = generatorContext.getRegistry().getCoercion(argument.getType(), returnType);
        return generatorContext.generateCall(function, (List<ByteCodeNode>)ImmutableList.of((Object)generatorContext.generate(argument)));
    }
}

