/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public final class Bootstrap {
    public static final Method BOOTSTRAP_METHOD;

    private Bootstrap() {
    }

    public static CallSite bootstrap(MethodHandles.Lookup callerLookup, String name, MethodType type, long bindingId) {
        try {
            ClassLoader classLoader = callerLookup.lookupClass().getClassLoader();
            Preconditions.checkArgument((boolean)(classLoader instanceof DynamicClassLoader), (String)"Expected %s's classloader to be of type %s", (Object[])new Object[]{callerLookup.lookupClass().getName(), DynamicClassLoader.class.getName()});
            DynamicClassLoader dynamicClassLoader = (DynamicClassLoader)classLoader;
            MethodHandle target = dynamicClassLoader.getCallSiteBindings().get(bindingId);
            Preconditions.checkArgument((target != null ? 1 : 0) != 0, (String)"Binding %s for function %s%s not found", (Object[])new Object[]{bindingId, name, type.parameterList()});
            return new ConstantCallSite(target);
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        try {
            BOOTSTRAP_METHOD = Bootstrap.class.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

