/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.gen.ArrayMapByteCodeExpression;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InvokeFunctionByteCodeExpression;
import java.util.function.Function;

public final class ArrayGeneratorUtils {
    private ArrayGeneratorUtils() {
    }

    public static ArrayMapByteCodeExpression map(Scope scope, CallSiteBinder binder, TypeManager typeManager, Variable array, FunctionInfo elementFunction) {
        return ArrayGeneratorUtils.map(scope, binder, typeManager, array, elementFunction.getSignature(), (ByteCodeExpression element) -> InvokeFunctionByteCodeExpression.invokeFunction(scope, binder, elementFunction, element));
    }

    public static ArrayMapByteCodeExpression map(Scope scope, CallSiteBinder binder, TypeManager typeManager, ByteCodeExpression array, Signature mapperSignature, Function<ByteCodeExpression, ByteCodeExpression> mapper) {
        Type fromElementType = typeManager.getType(mapperSignature.getArgumentTypes().get(0));
        Type toElementType = typeManager.getType(mapperSignature.getReturnType());
        return ArrayGeneratorUtils.map(scope, binder, array, fromElementType, toElementType, mapper);
    }

    public static ArrayMapByteCodeExpression map(Scope scope, CallSiteBinder binder, ByteCodeExpression array, Type fromElementType, Type toElementType, Function<ByteCodeExpression, ByteCodeExpression> mapper) {
        return new ArrayMapByteCodeExpression(scope, binder, array, fromElementType, toElementType, mapper);
    }
}

