/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Preconditions;

public class WindowFunctionValidator
extends DefaultExpressionTraversalVisitor<Void, Analysis> {
    protected Void visitFunctionCall(FunctionCall functionCall, Analysis analysis) {
        Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        FunctionInfo functionInfo = analysis.getFunctionInfo(functionCall);
        if (functionInfo != null && functionInfo.isWindow() && !functionInfo.isAggregate() && !functionCall.getWindow().isPresent()) {
            throw new SemanticException(SemanticErrorCode.WINDOW_REQUIRES_OVER, (Node)functionCall, "Window function %s requires an OVER clause", functionInfo.getName());
        }
        return (Void)super.visitFunctionCall(functionCall, (Object)analysis);
    }
}

