/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.AggregateExtractor;
import com.facebook.presto.sql.analyzer.AggregationAnalyzer;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.AnalysisContext;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.WindowFunctionExtractor;
import com.facebook.presto.sql.analyzer.WindowFunctionValidator;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TupleAnalyzer
extends DefaultTraversalVisitor<TupleDescriptor, AnalysisContext> {
    private final Analysis analysis;
    private final Session session;
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final boolean experimentalSyntaxEnabled;

    public TupleAnalyzer(Analysis analysis, Session session, Metadata metadata, SqlParser sqlParser, boolean experimentalSyntaxEnabled) {
        Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.analysis = analysis;
        this.session = session;
        this.metadata = metadata;
        this.sqlParser = sqlParser;
        this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
    }

    protected TupleDescriptor visitUnnest(Unnest node, AnalysisContext context) {
        ImmutableList.Builder outputFields = ImmutableList.builder();
        for (Expression expression : node.getExpressions()) {
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, context.getLateralTupleDescriptor(), context);
            Type expressionType = expressionAnalysis.getType(expression);
            if (expressionType instanceof ArrayType) {
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((ArrayType)expressionType).getElementType()));
                continue;
            }
            if (expressionType instanceof MapType) {
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getKeyType()));
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getValueType()));
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot unnest type: " + expressionType);
        }
        if (node.isWithOrdinality()) {
            outputFields.add((Object)Field.newUnqualified(Optional.empty(), (Type)BigintType.BIGINT));
        }
        TupleDescriptor descriptor = new TupleDescriptor((List<Field>)outputFields.build());
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitTable(Table table, AnalysisContext context) {
        Object name;
        Query query;
        if (!table.getName().getPrefix().isPresent() && (query = context.getNamedQuery((String)(name = table.getName().getSuffix()))) != null) {
            this.analysis.registerNamedQuery(table, query);
            TupleDescriptor queryDescriptor = this.analysis.getOutputDescriptor((Node)query);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (Field field : queryDescriptor.getAllFields()) {
                fields.add((Object)Field.newQualified(QualifiedName.of((String)name, (String[])new String[0]), field.getName(), field.getType(), false));
            }
            TupleDescriptor descriptor = new TupleDescriptor((List<Field>)fields.build());
            this.analysis.setOutputDescriptor((Node)table, descriptor);
            return descriptor;
        }
        name = MetadataUtil.createQualifiedTableName(this.session, table.getName());
        Optional<ViewDefinition> optionalView = this.metadata.getView(this.session, (QualifiedTableName)name);
        if (optionalView.isPresent()) {
            ViewDefinition view = optionalView.get();
            Query query2 = this.parseView(view.getOriginalSql(), (QualifiedTableName)name, table);
            this.analysis.registerNamedQuery(table, query2);
            TupleDescriptor descriptor = this.analyzeView(query2, (QualifiedTableName)name, view.getCatalog(), view.getSchema(), table);
            if (TupleAnalyzer.isViewStale(view.getColumns(), descriptor.getVisibleFields())) {
                throw new SemanticException(SemanticErrorCode.VIEW_IS_STALE, (Node)table, "View '%s' is stale; it must be re-created", name);
            }
            this.analysis.setOutputDescriptor((Node)table, descriptor);
            return descriptor;
        }
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, (QualifiedTableName)name);
        if (!tableHandle.isPresent()) {
            if (!this.metadata.getCatalogNames().containsKey(((QualifiedTableName)name).getCatalogName())) {
                throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)table, "Catalog %s does not exist", ((QualifiedTableName)name).getCatalogName());
            }
            if (!this.metadata.listSchemaNames(this.session, ((QualifiedTableName)name).getCatalogName()).contains(((QualifiedTableName)name).getSchemaName())) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)table, "Schema %s does not exist", ((QualifiedTableName)name).getSchemaName());
            }
            if (table.getName().getSuffix().equalsIgnoreCase("DUAL")) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "DUAL table is no longer supported. Please use VALUES or FROM-less queries instead", new Object[0]);
            }
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "Table %s does not exist", name);
        }
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle.get());
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, tableHandle.get());
        ImmutableList.Builder fields = ImmutableList.builder();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            Field field = Field.newQualified(table.getName(), Optional.of(column.getName()), column.getType(), column.isHidden());
            fields.add((Object)field);
            ColumnHandle columnHandle = columnHandles.get(column.getName());
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Unknown field %s", (Object[])new Object[]{field});
            this.analysis.setColumn(field, columnHandle);
        }
        this.analysis.registerTable(table, tableHandle.get());
        TupleDescriptor descriptor = new TupleDescriptor((List<Field>)fields.build());
        this.analysis.setOutputDescriptor((Node)table, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitAliasedRelation(AliasedRelation relation, AnalysisContext context) {
        int totalColumns;
        TupleDescriptor child = (TupleDescriptor)this.process((Node)relation.getRelation(), context);
        if (relation.getColumnNames() != null && (totalColumns = child.getVisibleFieldCount()) != relation.getColumnNames().size()) {
            throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but '%s' has %s columns available", relation.getColumnNames().size(), relation.getAlias(), totalColumns);
        }
        TupleDescriptor descriptor = child.withAlias(relation.getAlias(), relation.getColumnNames());
        this.analysis.setOutputDescriptor((Node)relation, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitSampledRelation(final SampledRelation relation, AnalysisContext context) {
        if (relation.getColumnsToStratifyOn().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)relation, "STRATIFY ON is not yet implemented", new Object[0]);
        }
        if (!DependencyExtractor.extract(relation.getSamplePercentage()).isEmpty()) {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
        }
        IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, (Map<Symbol, Type>)ImmutableMap.of(), relation.getSamplePercentage());
        ExpressionInterpreter samplePercentageEval = ExpressionInterpreter.expressionOptimizer(relation.getSamplePercentage(), this.metadata, this.session, expressionTypes);
        Object samplePercentageObject = samplePercentageEval.optimize(new SymbolResolver(){

            @Override
            public Object getValue(Symbol symbol) {
                throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
            }
        });
        if (!(samplePercentageObject instanceof Number)) {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage should evaluate to a numeric expression", new Object[0]);
        }
        double samplePercentageValue = ((Number)samplePercentageObject).doubleValue();
        if (samplePercentageValue < 0.0) {
            throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be greater than or equal to 0", new Object[0]);
        }
        if (samplePercentageValue > 100.0 && (relation.getType() != SampledRelation.Type.POISSONIZED || relation.isRescaled())) {
            throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be less than or equal to 100", new Object[0]);
        }
        if (relation.isRescaled() && !this.experimentalSyntaxEnabled) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)relation, "Rescaling is not enabled", new Object[0]);
        }
        TupleDescriptor descriptor = (TupleDescriptor)this.process((Node)relation.getRelation(), context);
        this.analysis.setOutputDescriptor((Node)relation, descriptor);
        this.analysis.setSampleRatio(relation, samplePercentageValue / 100.0);
        return descriptor;
    }

    protected TupleDescriptor visitTableSubquery(TableSubquery node, AnalysisContext context) {
        StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, this.session, this.experimentalSyntaxEnabled, Optional.empty());
        TupleDescriptor descriptor = (TupleDescriptor)analyzer.process((Node)node.getQuery(), context);
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitQuerySpecification(QuerySpecification node, AnalysisContext parentContext) {
        AnalysisContext context = new AnalysisContext(parentContext);
        TupleDescriptor tupleDescriptor = this.analyzeFrom(node, context);
        node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, tupleDescriptor, context, (Expression)where));
        List<FieldOrExpression> outputExpressions = this.analyzeSelect(node, tupleDescriptor, context);
        List<FieldOrExpression> groupByExpressions = this.analyzeGroupBy(node, tupleDescriptor, context, outputExpressions);
        List<FieldOrExpression> orderByExpressions = this.analyzeOrderBy(node, tupleDescriptor, context, outputExpressions);
        this.analyzeHaving(node, tupleDescriptor, context);
        this.analyzeAggregations(node, tupleDescriptor, groupByExpressions, outputExpressions, orderByExpressions, context);
        this.analyzeWindowFunctions(node, outputExpressions, orderByExpressions);
        TupleDescriptor descriptor = this.computeOutputDescriptor(node, tupleDescriptor);
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitUnion(Union node, AnalysisContext context) {
        Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
        TupleAnalyzer analyzer = new TupleAnalyzer(this.analysis, this.session, this.metadata, this.sqlParser, this.experimentalSyntaxEnabled);
        TupleDescriptor[] descriptors = (TupleDescriptor[])node.getRelations().stream().map(relation -> ((TupleDescriptor)analyzer.process((Node)relation, context)).withOnlyVisibleFields()).toArray(TupleDescriptor[]::new);
        Type[] outputFieldTypes = (Type[])descriptors[0].getVisibleFields().stream().map(field -> field.getType()).toArray(Type[]::new);
        TupleDescriptor[] tupleDescriptorArray = descriptors;
        int n = tupleDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            int outputFieldSize = outputFieldTypes.length;
            TupleDescriptor descriptor = tupleDescriptorArray[i];
            int descFieldSize = descriptor.getVisibleFields().size();
            if (outputFieldSize != descFieldSize) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "union query has different number of fields: %d, %d", outputFieldSize, descFieldSize);
            }
            for (int i2 = 0; i2 < descriptor.getVisibleFields().size(); ++i2) {
                Type descFieldType = descriptor.getFieldByIndex(i2).getType();
                Optional<Type> commonSuperType = FunctionRegistry.getCommonSuperType(outputFieldTypes[i2], descFieldType);
                if (!commonSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "column %d in union query has incompatible types: %s, %s", i2, outputFieldTypes[i2].getDisplayName(), descFieldType.getDisplayName());
                }
                outputFieldTypes[i2] = commonSuperType.get();
            }
        }
        Field[] outputDescriptorFields = new Field[outputFieldTypes.length];
        TupleDescriptor firstDescriptor = descriptors[0].withOnlyVisibleFields();
        for (int i = 0; i < outputFieldTypes.length; ++i) {
            Field oldField = firstDescriptor.getFieldByIndex(i);
            outputDescriptorFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), outputFieldTypes[i], oldField.isHidden());
        }
        TupleDescriptor outputDescriptor = new TupleDescriptor(outputDescriptorFields);
        this.analysis.setOutputDescriptor((Node)node, outputDescriptor);
        block3: for (int i = 0; i < node.getRelations().size(); ++i) {
            Relation relation2 = (Relation)node.getRelations().get(i);
            TupleDescriptor descriptor = descriptors[i];
            for (int j = 0; j < descriptor.getVisibleFields().size(); ++j) {
                Type outputFieldType = outputFieldTypes[j];
                Type descFieldType = descriptor.getFieldByIndex(j).getType();
                if (outputFieldType.equals(descFieldType)) continue;
                this.analysis.addRelationCoercion(relation2, outputFieldTypes);
                continue block3;
            }
        }
        return outputDescriptor;
    }

    protected TupleDescriptor visitIntersect(Intersect node, AnalysisContext context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "INTERSECT not yet implemented", new Object[0]);
    }

    protected TupleDescriptor visitExcept(Except node, AnalysisContext context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "EXCEPT not yet implemented", new Object[0]);
    }

    protected TupleDescriptor visitJoin(Join node, AnalysisContext context) {
        JoinCriteria criteria = node.getCriteria().orElse(null);
        if (criteria instanceof NaturalJoin) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Natural join not supported", new Object[0]);
        }
        AnalysisContext leftContext = new AnalysisContext(context);
        TupleDescriptor left = (TupleDescriptor)this.process((Node)node.getLeft(), context);
        leftContext.setLateralTupleDescriptor(left);
        TupleDescriptor right = (TupleDescriptor)this.process((Node)node.getRight(), leftContext);
        Sets.SetView duplicateAliases = Sets.intersection(left.getRelationAliases(), right.getRelationAliases());
        if (!duplicateAliases.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.DUPLICATE_RELATION, (Node)node, "Relations appear more than once: %s", duplicateAliases);
        }
        TupleDescriptor output = left.joinWith(right);
        if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) {
            this.analysis.setOutputDescriptor((Node)node, output);
            return output;
        }
        if (criteria instanceof JoinUsing) {
            List columns = ((JoinUsing)criteria).getColumns();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (String column : columns) {
                QualifiedNameReference leftExpression = new QualifiedNameReference(QualifiedName.of((String)column, (String[])new String[0]));
                QualifiedNameReference rightExpression = new QualifiedNameReference(QualifiedName.of((String)column, (String[])new String[0]));
                ExpressionAnalysis leftExpressionAnalysis = this.analyzeExpression((Expression)leftExpression, left, context);
                ExpressionAnalysis rightExpressionAnalysis = this.analyzeExpression((Expression)rightExpression, right, context);
                Preconditions.checkState((boolean)leftExpressionAnalysis.getSubqueryInPredicates().isEmpty(), (Object)"INVARIANT");
                Preconditions.checkState((boolean)rightExpressionAnalysis.getSubqueryInPredicates().isEmpty(), (Object)"INVARIANT");
                this.addCoercionForJoinCriteria(node, (Expression)leftExpression, (Expression)rightExpression);
                expressions.add((Expression)new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)leftExpression, (Expression)rightExpression));
            }
            this.analysis.setJoinCriteria(node, ExpressionUtils.and(expressions));
        } else if (criteria instanceof JoinOn) {
            Expression expression = ((JoinOn)criteria).getExpression();
            ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(this.analysis, this.session, this.metadata, this.sqlParser, this.experimentalSyntaxEnabled);
            analyzer.analyze(expression, output, context);
            Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, expression, "JOIN");
            Expression canonicalized = CanonicalizeExpressions.canonicalizeExpression(expression);
            Object optimizedExpression = ExpressionInterpreter.expressionOptimizer(canonicalized, this.metadata, this.session, analyzer.getExpressionTypes()).optimize(NoOpSymbolResolver.INSTANCE);
            if (!(optimizedExpression instanceof Expression) && optimizedExpression instanceof Boolean) {
                optimizedExpression = optimizedExpression.equals(Boolean.TRUE) ? new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("0")) : new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("1"));
            }
            if (!(optimizedExpression instanceof Expression)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Join clause must be a boolean expression", new Object[0]);
            }
            analyzer = ExpressionAnalyzer.create(this.analysis, this.session, this.metadata, this.sqlParser, this.experimentalSyntaxEnabled);
            analyzer.analyze((Expression)optimizedExpression, output, context);
            this.analysis.addCoercions(analyzer.getExpressionCoercions());
            for (Expression conjunct : ExpressionUtils.extractConjuncts((Expression)optimizedExpression)) {
                Expression rightExpression;
                Expression leftExpression;
                if (!(conjunct instanceof ComparisonExpression)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Non-equi joins not supported: %s", conjunct);
                }
                ComparisonExpression comparison = (ComparisonExpression)conjunct;
                Set<QualifiedName> firstDependencies = DependencyExtractor.extract(comparison.getLeft());
                Set<QualifiedName> secondDependencies = DependencyExtractor.extract(comparison.getRight());
                if (Iterables.all(firstDependencies, left.canResolvePredicate()) && Iterables.all(secondDependencies, right.canResolvePredicate())) {
                    leftExpression = comparison.getLeft();
                    rightExpression = comparison.getRight();
                } else if (Iterables.all(firstDependencies, right.canResolvePredicate()) && Iterables.all(secondDependencies, left.canResolvePredicate())) {
                    leftExpression = comparison.getRight();
                    rightExpression = comparison.getLeft();
                } else {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Non-equi joins not supported: %s", conjunct);
                }
                ExpressionAnalysis leftExpressionAnalysis = this.analyzeExpression(leftExpression, left, context);
                ExpressionAnalysis rightExpressionAnalysis = this.analyzeExpression(rightExpression, right, context);
                this.addCoercionForJoinCriteria(node, leftExpression, rightExpression);
                this.analysis.addJoinInPredicates(node, new Analysis.JoinInPredicates(leftExpressionAnalysis.getSubqueryInPredicates(), rightExpressionAnalysis.getSubqueryInPredicates()));
            }
            this.analysis.setJoinCriteria(node, (Expression)optimizedExpression);
        } else {
            throw new UnsupportedOperationException("unsupported join criteria: " + criteria.getClass().getName());
        }
        this.analysis.setOutputDescriptor((Node)node, output);
        return output;
    }

    private void addCoercionForJoinCriteria(Join node, Expression leftExpression, Expression rightExpression) {
        Type rightType;
        Type leftType = this.analysis.getType(leftExpression);
        Optional<Type> superType = FunctionRegistry.getCommonSuperType(leftType, rightType = this.analysis.getType(rightExpression));
        if (!superType.isPresent()) {
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Join criteria has incompatible types: %s, %s", leftType.getDisplayName(), rightType.getDisplayName());
        }
        if (!leftType.equals(superType.get())) {
            this.analysis.addCoercion(leftExpression, superType.get());
        }
        if (!rightType.equals(superType.get())) {
            this.analysis.addCoercion(rightExpression, superType.get());
        }
    }

    protected TupleDescriptor visitValues(Values node, AnalysisContext context) {
        Preconditions.checkState((node.getRows().size() >= 1 ? 1 : 0) != 0);
        Set rowTypes = (Set)node.getRows().stream().map(row -> this.analyzeExpression((Expression)row, new TupleDescriptor(new Field[0]), context).getType((Expression)row)).map(type -> {
            if (type instanceof RowType) {
                return type.getTypeParameters();
            }
            return ImmutableList.of((Object)type);
        }).collect(ImmutableCollectors.toImmutableSet());
        ArrayList<Type> fieldTypes = new ArrayList<Type>((Collection)rowTypes.iterator().next());
        for (List rowType : rowTypes) {
            for (int i = 0; i < rowType.size(); ++i) {
                Type superType;
                Type fieldType = (Type)rowType.get(i);
                Optional<Type> commonSuperType = FunctionRegistry.getCommonSuperType(fieldType, superType = (Type)fieldTypes.get(i));
                if (!commonSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Values rows have mismatched types: %s vs %s", Iterables.get((Iterable)rowTypes, (int)0), Iterables.get((Iterable)rowTypes, (int)1));
                }
                fieldTypes.set(i, commonSuperType.get());
            }
        }
        for (Expression row2 : node.getRows()) {
            if (row2 instanceof Row) {
                List items = ((Row)row2).getItems();
                for (int i = 0; i < items.size(); ++i) {
                    Type expectedType = (Type)fieldTypes.get(i);
                    Expression item = (Expression)items.get(i);
                    if (this.analysis.getType(item).equals(expectedType)) continue;
                    this.analysis.addCoercion(item, expectedType);
                }
                continue;
            }
            Type expectedType = (Type)fieldTypes.get(0);
            if (this.analysis.getType(row2).equals(expectedType)) continue;
            this.analysis.addCoercion(row2, expectedType);
        }
        TupleDescriptor descriptor = new TupleDescriptor((List)fieldTypes.stream().map(valueType -> Field.newUnqualified(Optional.empty(), valueType)).collect(ImmutableCollectors.toImmutableList()));
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    private void analyzeWindowFunctions(QuerySpecification node, List<FieldOrExpression> outputExpressions, List<FieldOrExpression> orderByExpressions) {
        WindowFunctionExtractor extractor = new WindowFunctionExtractor();
        for (FieldOrExpression fieldOrExpression : Iterables.concat(outputExpressions, orderByExpressions)) {
            if (!fieldOrExpression.isExpression()) continue;
            extractor.process((Node)fieldOrExpression.getExpression(), null);
            new WindowFunctionValidator().process((Node)fieldOrExpression.getExpression(), this.analysis);
        }
        List<FunctionCall> windowFunctions = extractor.getWindowFunctions();
        for (FunctionCall windowFunction : windowFunctions) {
            Window window = (Window)windowFunction.getWindow().get();
            WindowFunctionExtractor nestedExtractor = new WindowFunctionExtractor();
            for (Expression argument : windowFunction.getArguments()) {
                nestedExtractor.process((Node)argument, null);
            }
            for (Expression expression2 : window.getPartitionBy()) {
                nestedExtractor.process((Node)expression2, null);
            }
            for (SortItem sortItem : window.getOrderBy()) {
                nestedExtractor.process((Node)sortItem.getSortKey(), null);
            }
            if (window.getFrame().isPresent()) {
                nestedExtractor.process((Node)window.getFrame().get(), null);
            }
            if (!nestedExtractor.getWindowFunctions().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside window function '%s': %s", windowFunction, extractor.getWindowFunctions());
            }
            if (windowFunction.isDistinct()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in window function parameters not yet supported: %s", windowFunction);
            }
            if (window.getFrame().isPresent()) {
                TupleAnalyzer.analyzeWindowFrame((WindowFrame)window.getFrame().get());
            }
            List argumentTypes = Lists.transform((List)windowFunction.getArguments(), expression -> this.analysis.getType((Expression)expression).getTypeSignature());
            FunctionInfo info = this.metadata.resolveFunction(windowFunction.getName(), argumentTypes, false);
            if (info.isWindow()) continue;
            throw new SemanticException(SemanticErrorCode.MUST_BE_WINDOW_FUNCTION, (Node)node, "Not a window function: %s", windowFunction.getName());
        }
        this.analysis.setWindowFunctions(node, windowFunctions);
    }

    private static void analyzeWindowFrame(WindowFrame frame) {
        FrameBound.Type startType = frame.getStart().getType();
        FrameBound.Type endType = frame.getEnd().orElse(new FrameBound(FrameBound.Type.CURRENT_ROW)).getType();
        if (startType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame start cannot be UNBOUNDED FOLLOWING", new Object[0]);
        }
        if (endType == FrameBound.Type.UNBOUNDED_PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame end cannot be UNBOUNDED PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.CURRENT_ROW && endType == FrameBound.Type.PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from CURRENT ROW cannot end with PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.CURRENT_ROW) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with CURRENT ROW", new Object[0]);
        }
        if (frame.getType() == WindowFrame.Type.RANGE && (startType == FrameBound.Type.PRECEDING || endType == FrameBound.Type.PRECEDING)) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame RANGE PRECEDING is only supported with UNBOUNDED", new Object[0]);
        }
        if (frame.getType() == WindowFrame.Type.RANGE && (startType == FrameBound.Type.FOLLOWING || endType == FrameBound.Type.FOLLOWING)) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame RANGE FOLLOWING is only supported with UNBOUNDED", new Object[0]);
        }
    }

    private void analyzeHaving(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        if (node.getHaving().isPresent()) {
            Expression predicate = (Expression)node.getHaving().get();
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, tupleDescriptor, context);
            this.analysis.addInPredicates((Node)node, expressionAnalysis.getSubqueryInPredicates());
            Type predicateType = expressionAnalysis.getType(predicate);
            if (!predicateType.equals(BooleanType.BOOLEAN) && !predicateType.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "HAVING clause must evaluate to a boolean: actual type %s", predicateType);
            }
            this.analysis.setHaving(node, predicate);
        }
    }

    private List<FieldOrExpression> analyzeOrderBy(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context, List<FieldOrExpression> outputExpressions) {
        List items = node.getOrderBy();
        ImmutableList.Builder orderByExpressionsBuilder = ImmutableList.builder();
        if (!items.isEmpty()) {
            ImmutableMultimap.Builder byAliasBuilder = ImmutableMultimap.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                Optional alias;
                if (!(item instanceof SingleColumn) || !(alias = ((SingleColumn)item).getAlias()).isPresent()) continue;
                byAliasBuilder.put((Object)QualifiedName.of((String)((String)alias.get()), (String[])new String[0]), (Object)((SingleColumn)item).getExpression());
            }
            ImmutableMultimap byAlias = byAliasBuilder.build();
            for (SortItem item : items) {
                Expression expression = item.getSortKey();
                FieldOrExpression orderByExpression = null;
                if (expression instanceof QualifiedNameReference && !((QualifiedNameReference)expression).getName().getPrefix().isPresent()) {
                    QualifiedName name = ((QualifiedNameReference)expression).getName();
                    Collection expressions = byAlias.get((Object)name);
                    if (expressions.size() > 1) {
                        throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)expression, "'%s' in ORDER BY is ambiguous", name.getSuffix());
                    }
                    if (expressions.size() == 1) {
                        orderByExpression = new FieldOrExpression((Expression)Iterables.getOnlyElement((Iterable)expressions));
                    }
                } else if (expression instanceof LongLiteral) {
                    Type type;
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    orderByExpression = outputExpressions.get((int)(ordinal - 1L));
                    if (orderByExpression.isExpression()) {
                        type = this.analysis.getType(orderByExpression.getExpression());
                        if (!type.isOrderable()) {
                            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "The type of expression in position %s is not orderable (actual: %s), and therefore cannot be used in ORDER BY: %s", ordinal, type, orderByExpression);
                        }
                    } else {
                        type = tupleDescriptor.getFieldByIndex(orderByExpression.getFieldIndex()).getType();
                        if (!type.isOrderable()) {
                            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "The type of expression in position %s is not orderable (actual: %s), and therefore cannot be used in ORDER BY", ordinal, type);
                        }
                    }
                }
                if (orderByExpression == null) {
                    orderByExpression = new FieldOrExpression(expression);
                }
                if (orderByExpression.isExpression()) {
                    ExpressionAnalysis expressionAnalysis = this.analyzeExpression(orderByExpression.getExpression(), tupleDescriptor, context);
                    this.analysis.addInPredicates((Node)node, expressionAnalysis.getSubqueryInPredicates());
                    Type type = expressionAnalysis.getType(orderByExpression.getExpression());
                    if (!type.isOrderable()) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", type, expression);
                    }
                }
                orderByExpressionsBuilder.add((Object)orderByExpression);
            }
        }
        ImmutableList orderByExpressions = orderByExpressionsBuilder.build();
        this.analysis.setOrderByExpressions((Node)node, (List<FieldOrExpression>)orderByExpressions);
        if (node.getSelect().isDistinct() && !outputExpressions.containsAll((Collection<?>)orderByExpressions)) {
            throw new SemanticException(SemanticErrorCode.ORDER_BY_MUST_BE_IN_SELECT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
        }
        return orderByExpressions;
    }

    private List<FieldOrExpression> analyzeGroupBy(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context, List<FieldOrExpression> outputExpressions) {
        ImmutableList.Builder groupByExpressionsBuilder = ImmutableList.builder();
        if (!node.getGroupBy().isEmpty()) {
            for (Expression expression : node.getGroupBy()) {
                Type type;
                FieldOrExpression groupByExpression;
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "GROUP BY position %s is not in select list", ordinal);
                    }
                    groupByExpression = outputExpressions.get((int)(ordinal - 1L));
                } else {
                    ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, tupleDescriptor, context);
                    this.analysis.addInPredicates((Node)node, expressionAnalysis.getSubqueryInPredicates());
                    groupByExpression = new FieldOrExpression(expression);
                }
                if (groupByExpression.isExpression()) {
                    Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, groupByExpression.getExpression(), "GROUP BY");
                    type = this.analysis.getType(groupByExpression.getExpression());
                } else {
                    type = tupleDescriptor.getFieldByIndex(groupByExpression.getFieldIndex()).getType();
                }
                if (!type.isComparable()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in GROUP BY", type);
                }
                groupByExpressionsBuilder.add((Object)groupByExpression);
            }
        }
        ImmutableList groupByExpressions = groupByExpressionsBuilder.build();
        this.analysis.setGroupByExpressions(node, (List<FieldOrExpression>)groupByExpressions);
        return groupByExpressions;
    }

    private TupleDescriptor computeOutputDescriptor(QuerySpecification node, TupleDescriptor inputTupleDescriptor) {
        ImmutableList.Builder outputFields = ImmutableList.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (item instanceof AllColumns) {
                Optional starPrefix = ((AllColumns)item).getPrefix();
                for (Field field : inputTupleDescriptor.resolveFieldsWithPrefix(starPrefix)) {
                    outputFields.add((Object)Field.newUnqualified(field.getName(), field.getType()));
                }
                continue;
            }
            if (item instanceof SingleColumn) {
                SingleColumn column = (SingleColumn)item;
                Optional<String> alias = column.getAlias();
                if (!alias.isPresent() && column.getExpression() instanceof QualifiedNameReference) {
                    alias = Optional.of(((QualifiedNameReference)column.getExpression()).getName().getSuffix());
                }
                outputFields.add((Object)Field.newUnqualified(alias, this.analysis.getType(column.getExpression())));
                continue;
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
        }
        return new TupleDescriptor((List<Field>)outputFields.build());
    }

    private List<FieldOrExpression> analyzeSelect(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (item instanceof AllColumns) {
                Optional starPrefix = ((AllColumns)item).getPrefix();
                List<Field> fields = tupleDescriptor.resolveFieldsWithPrefix(starPrefix);
                if (fields.isEmpty()) {
                    if (starPrefix.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)item, "Table '%s' not found", starPrefix.get());
                    }
                    throw new SemanticException(SemanticErrorCode.WILDCARD_WITHOUT_FROM, (Node)item, "SELECT * not allowed in queries without FROM clause", new Object[0]);
                }
                for (Field field : fields) {
                    int fieldIndex = tupleDescriptor.indexOf(field);
                    outputExpressionBuilder.add((Object)new FieldOrExpression(fieldIndex));
                    if (!node.getSelect().isDistinct() || field.getType().isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", field.getType());
                }
                continue;
            }
            if (item instanceof SingleColumn) {
                SingleColumn column = (SingleColumn)item;
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(column.getExpression(), tupleDescriptor, context);
                this.analysis.addInPredicates((Node)node, expressionAnalysis.getSubqueryInPredicates());
                outputExpressionBuilder.add((Object)new FieldOrExpression(column.getExpression()));
                Type type = expressionAnalysis.getType(column.getExpression());
                if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s): %s", type, column.getExpression());
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
        }
        ImmutableList result = outputExpressionBuilder.build();
        this.analysis.setOutputExpressions((Node)node, (List<FieldOrExpression>)result);
        return result;
    }

    public void analyzeWhere(Node node, TupleDescriptor tupleDescriptor, AnalysisContext context, Expression predicate) {
        Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, predicate, "WHERE");
        ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, tupleDescriptor, context);
        this.analysis.addInPredicates(node, expressionAnalysis.getSubqueryInPredicates());
        Type predicateType = expressionAnalysis.getType(predicate);
        if (!predicateType.equals(BooleanType.BOOLEAN)) {
            if (!predicateType.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause must evaluate to a boolean: actual type %s", predicateType);
            }
            this.analysis.addCoercion(predicate, (Type)BooleanType.BOOLEAN);
        }
        this.analysis.setWhere(node, predicate);
    }

    private TupleDescriptor analyzeFrom(QuerySpecification node, AnalysisContext context) {
        TupleDescriptor fromDescriptor = new TupleDescriptor(new Field[0]);
        if (node.getFrom().isPresent()) {
            TupleAnalyzer analyzer = new TupleAnalyzer(this.analysis, this.session, this.metadata, this.sqlParser, this.experimentalSyntaxEnabled);
            fromDescriptor = (TupleDescriptor)analyzer.process((Node)node.getFrom().get(), context);
        }
        return fromDescriptor;
    }

    private void analyzeAggregations(QuerySpecification node, TupleDescriptor tupleDescriptor, List<FieldOrExpression> groupByExpressions, List<FieldOrExpression> outputExpressions, List<FieldOrExpression> orderByExpressions, AnalysisContext context) {
        List<FunctionCall> aggregates = this.extractAggregates(node);
        if (context.isApproximate() && Iterables.any(aggregates, FunctionCall::isDistinct)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT aggregations not supported for approximate queries", new Object[0]);
        }
        if (!aggregates.isEmpty() || !groupByExpressions.isEmpty()) {
            for (FieldOrExpression fieldOrExpression : Iterables.concat(outputExpressions, orderByExpressions)) {
                this.verifyAggregations(node, groupByExpressions, tupleDescriptor, fieldOrExpression);
            }
            if (node.getHaving().isPresent()) {
                this.verifyAggregations(node, groupByExpressions, tupleDescriptor, new FieldOrExpression((Expression)node.getHaving().get()));
            }
        }
    }

    private List<FunctionCall> extractAggregates(QuerySpecification node) {
        AggregateExtractor extractor = new AggregateExtractor(this.metadata);
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (!(item instanceof SingleColumn)) continue;
            ((SingleColumn)item).getExpression().accept((AstVisitor)extractor, null);
        }
        for (SelectItem item : node.getOrderBy()) {
            item.getSortKey().accept((AstVisitor)extractor, null);
        }
        if (node.getHaving().isPresent()) {
            ((Expression)node.getHaving().get()).accept((AstVisitor)extractor, null);
        }
        List<FunctionCall> aggregates = extractor.getAggregates();
        this.analysis.setAggregates(node, aggregates);
        return aggregates;
    }

    private void verifyAggregations(QuerySpecification node, List<FieldOrExpression> groupByExpressions, TupleDescriptor tupleDescriptor, FieldOrExpression fieldOrExpression) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, this.metadata, tupleDescriptor);
        if (fieldOrExpression.isExpression()) {
            analyzer.analyze(fieldOrExpression.getExpression());
        } else {
            int fieldIndex = fieldOrExpression.getFieldIndex();
            if (!analyzer.analyze(fieldIndex)) {
                Field field = tupleDescriptor.getFieldByIndex(fieldIndex);
                if (field.getRelationAlias().isPresent()) {
                    if (field.getName().isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Column '%s.%s' not in GROUP BY clause", field.getRelationAlias().get(), field.getName().get());
                    }
                    throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Columns from '%s' not in GROUP BY clause", field.getRelationAlias().get());
                }
                if (field.getName().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Column '%s' not in GROUP BY clause", field.getName().get());
                }
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Some columns from FROM clause not in GROUP BY clause", new Object[0]);
            }
        }
    }

    private TupleDescriptor analyzeView(Query query, QualifiedTableName name, String catalog, String schema, Table node) {
        try {
            Session viewSession = Session.builder(this.metadata.getSessionPropertyManager()).setUser(this.session.getUser()).setSource(this.session.getSource().orElse(null)).setCatalog(catalog).setSchema(schema).setTimeZoneKey(this.session.getTimeZoneKey()).setLocale(this.session.getLocale()).setRemoteUserAddress(this.session.getRemoteUserAddress().orElse(null)).setUserAgent(this.session.getUserAgent().orElse(null)).setStartTime(this.session.getStartTime()).build();
            StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, viewSession, this.experimentalSyntaxEnabled, Optional.empty());
            return (TupleDescriptor)analyzer.process((Node)query, new AnalysisContext());
        }
        catch (RuntimeException e) {
            throw new SemanticException(SemanticErrorCode.VIEW_ANALYSIS_ERROR, (Node)node, "Failed analyzing stored view '%s': %s", name, e.getMessage());
        }
    }

    private Query parseView(String view, QualifiedTableName name, Table node) {
        try {
            Statement statement = this.sqlParser.createStatement(view);
            return Types.checkType(statement, Query.class, "parsed view");
        }
        catch (ParsingException e) {
            throw new SemanticException(SemanticErrorCode.VIEW_PARSE_ERROR, (Node)node, "Failed parsing stored view '%s': %s", name, e.getMessage());
        }
    }

    private static boolean isViewStale(List<ViewDefinition.ViewColumn> columns, Collection<Field> fields) {
        if (columns.size() != fields.size()) {
            return true;
        }
        ImmutableList fieldList = ImmutableList.copyOf(fields);
        for (int i = 0; i < columns.size(); ++i) {
            ViewDefinition.ViewColumn column = columns.get(i);
            Field field = (Field)fieldList.get(i);
            if (column.getName().equals(field.getName().orElse(null)) && column.getType().equals(field.getType())) continue;
            return true;
        }
        return false;
    }

    private ExpressionAnalysis analyzeExpression(Expression expression, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        return ExpressionAnalyzer.analyzeExpression(this.session, this.metadata, this.sqlParser, tupleDescriptor, this.analysis, this.experimentalSyntaxEnabled, context, expression);
    }

    public static class DependencyExtractor {
        public static Set<QualifiedName> extract(Expression expression) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            Visitor visitor = new Visitor();
            visitor.process((Node)expression, builder);
            return builder.build();
        }

        private static class Visitor
        extends DefaultExpressionTraversalVisitor<Void, ImmutableSet.Builder<QualifiedName>> {
            private Visitor() {
            }

            protected Void visitQualifiedNameReference(QualifiedNameReference node, ImmutableSet.Builder<QualifiedName> builder) {
                builder.add((Object)node.getName());
                return null;
            }
        }
    }
}

