/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimeZoneNotSupportedException;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

final class ResourceUtil {
    private ResourceUtil() {
    }

    public static Session createSessionForRequest(HttpServletRequest servletRequest, SessionPropertyManager sessionPropertyManager) {
        String language;
        Session.SessionBuilder sessionBuilder = Session.builder(sessionPropertyManager).setUser(ResourceUtil.getRequiredHeader(servletRequest, "X-Presto-User", "User")).setSource(servletRequest.getHeader("X-Presto-Source")).setCatalog(ResourceUtil.getRequiredHeader(servletRequest, "X-Presto-Catalog", "Catalog")).setSchema(ResourceUtil.getRequiredHeader(servletRequest, "X-Presto-Schema", "Schema")).setRemoteUserAddress(servletRequest.getRemoteAddr()).setUserAgent(servletRequest.getHeader("User-Agent"));
        String timeZoneId = servletRequest.getHeader("X-Presto-Time-Zone");
        if (timeZoneId != null) {
            sessionBuilder.setTimeZoneKey(ResourceUtil.getTimeZoneKey(timeZoneId));
        }
        if ((language = servletRequest.getHeader("X-Presto-Language")) != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(language));
        }
        HashMultimap sessionPropertiesByCatalog = HashMultimap.create();
        for (String string : ResourceUtil.splitSessionHeader(servletRequest.getHeaders("X-Presto-Session"))) {
            ResourceUtil.parseSessionHeader(string, (Multimap<String, Map.Entry<String, String>>)sessionPropertiesByCatalog, sessionPropertyManager);
        }
        sessionBuilder.setSystemProperties(ResourceUtil.toMap(sessionPropertiesByCatalog.get(null)));
        for (Map.Entry entry : sessionPropertiesByCatalog.asMap().entrySet()) {
            if (entry.getKey() == null) continue;
            sessionBuilder.setCatalogProperties((String)entry.getKey(), ResourceUtil.toMap((Iterable)entry.getValue()));
        }
        return sessionBuilder.build();
    }

    private static List<String> splitSessionHeader(Enumeration<String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return (List)Collections.list(headers).stream().map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableList());
    }

    private static void parseSessionHeader(String header, Multimap<String, Map.Entry<String, String>> sessionPropertiesByCatalog, SessionPropertyManager sessionPropertyManager) {
        String name;
        String catalog;
        List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
        ResourceUtil.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Session");
        String fullPropertyName = (String)nameValue.get(0);
        List nameParts = Splitter.on((char)'.').splitToList((CharSequence)fullPropertyName);
        if (nameParts.size() == 1) {
            catalog = null;
            name = (String)nameParts.get(0);
        } else if (nameParts.size() == 2) {
            catalog = (String)nameParts.get(0);
            name = (String)nameParts.get(1);
        } else {
            throw ResourceUtil.badRequest(String.format("Invalid %s header", "X-Presto-Session"));
        }
        ResourceUtil.assertRequest(catalog == null || !catalog.isEmpty(), "Invalid %s header", "X-Presto-Session");
        ResourceUtil.assertRequest(!name.isEmpty(), "Invalid %s header", "X-Presto-Session");
        String value = (String)nameValue.get(1);
        PropertyMetadata<?> metadata = sessionPropertyManager.getSessionPropertyMetadata(fullPropertyName);
        try {
            sessionPropertyManager.decodeProperty(fullPropertyName, value, metadata.getJavaType());
        }
        catch (RuntimeException e) {
            throw ResourceUtil.badRequest(String.format("Invalid %s header", "X-Presto-Session"));
        }
        sessionPropertiesByCatalog.put((Object)catalog, (Object)Maps.immutableEntry((Object)name, (Object)value));
    }

    private static <K, V> Map<K, V> toMap(Iterable<? extends Map.Entry<K, V>> entries) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, V> entry : entries) {
            builder.put(entry);
        }
        return builder.build();
    }

    private static String getRequiredHeader(HttpServletRequest servletRequest, String name, String description) {
        String value = servletRequest.getHeader(name);
        ResourceUtil.assertRequest(!Strings.isNullOrEmpty((String)value), description + " (%s) is empty", name);
        return value;
    }

    public static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw ResourceUtil.badRequest(String.format(format, args));
        }
    }

    private static TimeZoneKey getTimeZoneKey(String timeZoneId) {
        try {
            return TimeZoneKey.getTimeZoneKey((String)timeZoneId);
        }
        catch (TimeZoneNotSupportedException e) {
            throw ResourceUtil.badRequest(e.getMessage());
        }
    }

    private static WebApplicationException badRequest(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)message).build());
    }
}

