/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.ResourceUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.http.client.HttpUriBuilder;
import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/query")
public class QueryResource {
    private final QueryManager queryManager;
    private final SessionPropertyManager sessionPropertyManager;

    @Inject
    public QueryResource(QueryManager queryManager, SessionPropertyManager sessionPropertyManager) {
        this.queryManager = (QueryManager)Preconditions.checkNotNull((Object)queryManager, (Object)"queryManager is null");
        this.sessionPropertyManager = (SessionPropertyManager)Preconditions.checkNotNull((Object)sessionPropertyManager, (Object)"sessionPropertyManager is null");
    }

    @GET
    public List<BasicQueryInfo> getAllQueryInfo() {
        return QueryResource.extractBasicQueryInfo(this.queryManager.getAllQueryInfo());
    }

    private static List<BasicQueryInfo> extractBasicQueryInfo(List<QueryInfo> allQueryInfo) {
        ImmutableList.Builder basicQueryInfo = ImmutableList.builder();
        for (QueryInfo queryInfo : allQueryInfo) {
            basicQueryInfo.add((Object)new BasicQueryInfo(queryInfo));
        }
        return basicQueryInfo.build();
    }

    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        try {
            QueryInfo queryInfo = this.queryManager.getQueryInfo(queryId);
            return Response.ok((Object)queryInfo).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response createQuery(String statement, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo) {
        ResourceUtil.assertRequest(!Strings.isNullOrEmpty((String)statement), "SQL statement is empty", new Object[0]);
        Session session = ResourceUtil.createSessionForRequest(servletRequest, this.sessionPropertyManager);
        QueryInfo queryInfo = this.queryManager.createQuery(session, statement);
        URI pagesUri = HttpUriBuilder.uriBuilderFrom((URI)uriInfo.getRequestUri()).appendPath(queryInfo.getQueryId().toString()).build();
        return Response.created((URI)pagesUri).entity((Object)queryInfo).build();
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        this.queryManager.cancelQuery(queryId);
    }

    @DELETE
    @Path(value="stage/{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId) {
        Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        this.queryManager.cancelStage(stageId);
    }
}

