/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

class PluginClassLoader
extends URLClassLoader {
    private final List<String> hiddenClasses;
    private final List<String> parentFirstClasses;
    private final List<String> hiddenResources;
    private final List<String> parentFirstResources;

    public PluginClassLoader(List<URL> urls, ClassLoader parent, Iterable<String> hiddenClasses, Iterable<String> parentFirstClasses) {
        this(urls, parent, hiddenClasses, parentFirstClasses, Iterables.transform(hiddenClasses, PluginClassLoader::classNameToResource), Iterables.transform(parentFirstClasses, PluginClassLoader::classNameToResource));
    }

    public PluginClassLoader(List<URL> urls, ClassLoader parent, Iterable<String> hiddenClasses, Iterable<String> parentFirstClasses, Iterable<String> hiddenResources, Iterable<String> parentFirstResources) {
        super(urls.toArray(new URL[urls.size()]), (ClassLoader)Preconditions.checkNotNull((Object)parent, (Object)"parent is null"));
        this.hiddenClasses = ImmutableList.copyOf(hiddenClasses);
        this.parentFirstClasses = ImmutableList.copyOf(parentFirstClasses);
        this.hiddenResources = ImmutableList.copyOf(hiddenResources);
        this.parentFirstResources = ImmutableList.copyOf(parentFirstResources);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cachedClass = this.findLoadedClass(name);
            if (cachedClass != null) {
                return this.resolveClass(cachedClass, resolve);
            }
            if (!this.isParentFirstClass(name)) {
                try {
                    Class<?> clazz = this.findClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException clazz) {
                    // empty catch block
                }
            }
            if (!this.isHiddenClass(name)) {
                try {
                    Class<?> clazz = this.getParent().loadClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException clazz) {
                    // empty catch block
                }
            }
            if (this.isParentFirstClass(name)) {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            throw new ClassNotFoundException(name);
        }
    }

    private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean isParentFirstClass(String name) {
        for (String nonOverridableClass : this.parentFirstClasses) {
            if (!name.startsWith(nonOverridableClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenClass(String name) {
        for (String hiddenClass : this.hiddenClasses) {
            if (!name.startsWith(hiddenClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (!this.isParentFirstResource(name) && (url = this.findResource(name)) != null) {
            return url;
        }
        if (!this.isHiddenResource(name) && (url = this.getParent().getResource(name)) != null) {
            return url;
        }
        if (this.isParentFirstResource(name) && (url = this.findResource(name)) != null) {
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        UnmodifiableIterator myResources;
        ArrayList<UnmodifiableIterator> resources = new ArrayList<UnmodifiableIterator>();
        if (!this.isParentFirstResource(name)) {
            myResources = Iterators.forEnumeration(this.findResources(name));
            resources.add(myResources);
        }
        if (!this.isHiddenResource(name)) {
            UnmodifiableIterator parentResources = Iterators.forEnumeration(this.getParent().getResources(name));
            resources.add(parentResources);
        }
        if (this.isParentFirstResource(name)) {
            myResources = Iterators.forEnumeration(this.findResources(name));
            resources.add(myResources);
        }
        return Iterators.asEnumeration((Iterator)Iterators.concat(resources.iterator()));
    }

    private boolean isParentFirstResource(String name) {
        for (String nonOverridableResource : this.parentFirstResources) {
            if (!name.startsWith(nonOverridableResource)) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenResource(String name) {
        for (String hiddenResource : this.hiddenResources) {
            if (!name.startsWith(hiddenResource)) continue;
            return true;
        }
        return false;
    }

    private static String classNameToResource(String className) {
        return className.replace('.', '/');
    }
}

