/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class BasicQueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final QueryState state;
    private final StandardErrorCode.ErrorType errorType;
    private final ErrorCode errorCode;
    private final boolean scheduled;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final URI self;
    private final String query;
    private final Duration elapsedTime;
    private final DateTime endTime;
    private final DateTime createTime;
    private final int runningDrivers;
    private final int queuedDrivers;
    private final int completedDrivers;
    private final int totalDrivers;

    @JsonCreator
    public BasicQueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="state") QueryState state, @JsonProperty(value="errorType") StandardErrorCode.ErrorType errorType, @JsonProperty(value="errorCode") ErrorCode errorCode, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="self") URI self, @JsonProperty(value="query") String query, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="totalDrivers") int totalDrivers) {
        this.queryId = (QueryId)Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        this.session = (SessionRepresentation)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.state = (QueryState)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state is null"));
        this.errorType = errorType;
        this.errorCode = errorCode;
        this.scheduled = scheduled;
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.self = (URI)Preconditions.checkNotNull((Object)self, (Object)"self is null");
        this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.elapsedTime = elapsedTime;
        this.endTime = endTime;
        this.createTime = createTime;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is less than zero");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is less than zero");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is less than zero");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is less than zero");
        this.totalDrivers = totalDrivers;
    }

    public BasicQueryInfo(QueryInfo queryInfo) {
        this(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), queryInfo.getErrorType(), queryInfo.getErrorCode(), queryInfo.isScheduled(), queryInfo.getQueryStats().isFullyBlocked(), queryInfo.getQueryStats().getBlockedReasons(), queryInfo.getSelf(), queryInfo.getQuery(), queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getEndTime(), queryInfo.getQueryStats().getCreateTime(), queryInfo.getQueryStats().getRunningDrivers(), queryInfo.getQueryStats().getQueuedDrivers(), queryInfo.getQueryStats().getCompletedDrivers(), queryInfo.getQueryStats().getTotalDrivers());
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @Nullable
    @JsonProperty
    public StandardErrorCode.ErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).toString();
    }
}

