/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.ForAsyncHttpResponse;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AsyncHttpExecutionMBean {
    private final ThreadPoolExecutorMBean executorMBean;

    @Inject
    public AsyncHttpExecutionMBean(@ForAsyncHttpResponse ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.executorMBean = new ThreadPoolExecutorMBean(Types.checkType(executor, ThreadPoolExecutor.class, "executor"));
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }
}

