/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.FrameInfo;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.operator.window.WindowIndex;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.List;

public final class WindowPartition {
    private final PagesIndex pagesIndex;
    private final int partitionStart;
    private final int partitionEnd;
    private final int[] outputChannels;
    private final List<WindowFunction> windowFunctions;
    private final FrameInfo frameInfo;
    private final PagesHashStrategy peerGroupHashStrategy;
    private int peerGroupStart;
    private int peerGroupEnd;
    private int frameStart;
    private int frameEnd;
    private int currentPosition;

    public WindowPartition(PagesIndex pagesIndex, int partitionStart, int partitionEnd, int[] outputChannels, List<WindowFunction> windowFunctions, FrameInfo frameInfo, PagesHashStrategy peerGroupHashStrategy) {
        this.pagesIndex = pagesIndex;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.outputChannels = outputChannels;
        this.windowFunctions = windowFunctions;
        this.frameInfo = frameInfo;
        this.peerGroupHashStrategy = peerGroupHashStrategy;
        WindowIndex windowIndex = new WindowIndex(pagesIndex, partitionStart, partitionEnd);
        for (WindowFunction windowFunction : windowFunctions) {
            windowFunction.reset(windowIndex);
        }
        this.currentPosition = partitionStart;
        this.updatePeerGroup();
    }

    public int getPartitionEnd() {
        return this.partitionEnd;
    }

    public boolean hasNext() {
        return this.currentPosition < this.partitionEnd;
    }

    public void processNextRow(PageBuilder pageBuilder) {
        int channel;
        Preconditions.checkState((boolean)this.hasNext(), (Object)"No more rows in partition");
        pageBuilder.declarePosition();
        for (channel = 0; channel < this.outputChannels.length; ++channel) {
            this.pagesIndex.appendTo(this.outputChannels[channel], this.currentPosition, pageBuilder.getBlockBuilder(channel));
        }
        if (this.currentPosition == this.peerGroupEnd) {
            this.updatePeerGroup();
        }
        this.updateFrame();
        for (WindowFunction function : this.windowFunctions) {
            function.processRow(pageBuilder.getBlockBuilder(channel), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1, this.frameStart, this.frameEnd);
            ++channel;
        }
        ++this.currentPosition;
    }

    private void updatePeerGroup() {
        this.peerGroupStart = this.currentPosition;
        this.peerGroupEnd = this.peerGroupStart + 1;
        while (this.peerGroupEnd < this.partitionEnd && this.pagesIndex.positionEqualsPosition(this.peerGroupHashStrategy, this.peerGroupStart, this.peerGroupEnd)) {
            ++this.peerGroupEnd;
        }
    }

    private void updateFrame() {
        int rowPosition = this.currentPosition - this.partitionStart;
        int endPosition = this.partitionEnd - this.partitionStart - 1;
        this.frameStart = this.frameInfo.getStartType() == FrameBound.Type.UNBOUNDED_PRECEDING ? 0 : (this.frameInfo.getStartType() == FrameBound.Type.PRECEDING ? WindowPartition.preceding(rowPosition, this.getStartValue()) : (this.frameInfo.getStartType() == FrameBound.Type.FOLLOWING ? WindowPartition.following(rowPosition, endPosition, this.getStartValue()) : (this.frameInfo.getType() == WindowFrame.Type.RANGE ? this.peerGroupStart - this.partitionStart : rowPosition)));
        this.frameEnd = this.frameInfo.getEndType() == FrameBound.Type.UNBOUNDED_FOLLOWING ? endPosition : (this.frameInfo.getEndType() == FrameBound.Type.PRECEDING ? WindowPartition.preceding(rowPosition, this.getEndValue()) : (this.frameInfo.getEndType() == FrameBound.Type.FOLLOWING ? WindowPartition.following(rowPosition, endPosition, this.getEndValue()) : (this.frameInfo.getType() == WindowFrame.Type.RANGE ? this.peerGroupEnd - this.partitionStart - 1 : rowPosition)));
        if (this.emptyFrame(rowPosition, endPosition)) {
            this.frameStart = -1;
            this.frameEnd = -1;
        }
    }

    private boolean emptyFrame(int rowPosition, int endPosition) {
        if (this.frameInfo.getStartType() != this.frameInfo.getEndType()) {
            return false;
        }
        FrameBound.Type type = this.frameInfo.getStartType();
        if (type != FrameBound.Type.PRECEDING && type != FrameBound.Type.FOLLOWING) {
            return false;
        }
        long start = this.getStartValue();
        long end = this.getEndValue();
        if (type == FrameBound.Type.PRECEDING) {
            return start < end || start > (long)rowPosition && end > (long)rowPosition;
        }
        int positions = endPosition - rowPosition;
        return start > end || start > (long)positions && end > (long)positions;
    }

    private static int preceding(int rowPosition, long value) {
        if (value > (long)rowPosition) {
            return 0;
        }
        return Ints.checkedCast((long)((long)rowPosition - value));
    }

    private static int following(int rowPosition, int endPosition, long value) {
        if (value > (long)(endPosition - rowPosition)) {
            return endPosition;
        }
        return Ints.checkedCast((long)((long)rowPosition + value));
    }

    private long getStartValue() {
        return this.getFrameValue(this.frameInfo.getStartChannel(), "starting");
    }

    private long getEndValue() {
        return this.getFrameValue(this.frameInfo.getEndChannel(), "ending");
    }

    private long getFrameValue(int channel, String type) {
        Failures.checkCondition(!this.pagesIndex.isNull(channel, this.currentPosition), (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame %s offset must not be null", type);
        long value = this.pagesIndex.getLong(channel, this.currentPosition);
        Failures.checkCondition(value >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame %s offset must not be negative", new Object[0]);
        return value;
    }
}

