/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParametricWindowFunction
implements ParametricFunction {
    private final WindowFunctionSupplier supplier;

    public ParametricWindowFunction(WindowFunctionSupplier supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is null");
    }

    @Override
    public Signature getSignature() {
        return this.supplier.getSignature();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isApproximate() {
        return false;
    }

    @Override
    public boolean isWindow() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isUnbound() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.supplier.getDescription();
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (String)"expected exactly one type: %s", (Object[])new Object[]{types});
        String typeVariable = (String)Iterables.getOnlyElement(types.keySet());
        TypeSignature type = ((Type)Iterables.getOnlyElement(types.values())).getTypeSignature();
        List argumentTypes = (List)this.supplier.getSignature().getArgumentTypes().stream().map(argument -> argument.getBase().equals(typeVariable) ? type : argument).collect(ImmutableCollectors.toImmutableList());
        Signature signature = new Signature(this.getSignature().getName(), type, argumentTypes);
        return new FunctionInfo(signature, this.getDescription(), this.supplier);
    }
}

