/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RowFieldReference
extends ParametricScalar {
    private static final Map<String, MethodHandle> METHOD_HANDLE_MAP;
    private final Signature signature;
    private final MethodHandle methodHandle;
    private static final MethodHandle METHOD_HANDLE_OBJECT;

    public RowFieldReference(RowType type, String fieldName) {
        Type returnType = null;
        int index = 0;
        for (RowType.RowField field : type.getFields()) {
            if (field.getName().equals(Optional.of(fieldName))) {
                returnType = field.getType();
                break;
            }
            ++index;
        }
        Preconditions.checkNotNull((Object)returnType, (String)"%s not found in row type %s", (Object[])new Object[]{fieldName, type});
        this.signature = new Signature(QueryUtil.mangleFieldReference((String)fieldName), returnType.getTypeSignature(), type.getTypeSignature());
        String stackType = returnType.getJavaType().getSimpleName().toLowerCase();
        MethodHandle methodHandle = METHOD_HANDLE_MAP.containsKey(stackType) ? METHOD_HANDLE_MAP.get(stackType) : METHOD_HANDLE_OBJECT;
        this.methodHandle = methodHandle.bindTo(returnType).bindTo(index);
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkNotNull((Object)this.methodHandle, (Object)"methodHandle is null");
        return new FunctionInfo(this.signature, this.getDescription(), this.isHidden(), this.methodHandle, this.isDeterministic(), true, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Long longAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : Long.valueOf(type.getLong(row, field.intValue()));
    }

    public static Boolean booleanAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : Boolean.valueOf(type.getBoolean(row, field.intValue()));
    }

    public static Double doubleAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : Double.valueOf(type.getDouble(row, field.intValue()));
    }

    public static Slice sliceAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : type.getSlice(row, field.intValue());
    }

    public static Object objectAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : type.getObject(row, field.intValue());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"long", (Object)Reflection.methodHandle(RowFieldReference.class, "longAccessor", Type.class, Integer.class, Block.class));
        builder.put((Object)"double", (Object)Reflection.methodHandle(RowFieldReference.class, "doubleAccessor", Type.class, Integer.class, Block.class));
        builder.put((Object)"boolean", (Object)Reflection.methodHandle(RowFieldReference.class, "booleanAccessor", Type.class, Integer.class, Block.class));
        builder.put((Object)"slice", (Object)Reflection.methodHandle(RowFieldReference.class, "sliceAccessor", Type.class, Integer.class, Block.class));
        METHOD_HANDLE_MAP = builder.build();
        METHOD_HANDLE_OBJECT = Reflection.methodHandle(RowFieldReference.class, "objectAccessor", Type.class, Integer.class, Block.class);
    }
}

