/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.MapEqualOperator;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class MapNotEqualOperator
extends ParametricOperator {
    public static final MapNotEqualOperator MAP_NOT_EQUAL = new MapNotEqualOperator();
    private static final TypeSignature RETURN_TYPE = TypeSignature.parseTypeSignature((String)"boolean");
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapNotEqualOperator.class, "notEqual", MethodHandle.class, MethodHandle.class, MethodHandle.class, Type.class, Type.class, Block.class, Block.class);

    private MapNotEqualOperator() {
        super(OperatorType.NOT_EQUAL, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.comparableTypeParameter("V")), "boolean", (List<String>)ImmutableList.of((Object)"map<K,V>", (Object)"map<K,V>"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Type type = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
        TypeSignature typeSignature = type.getTypeSignature();
        MethodHandle keyEqualsFunction = functionRegistry.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)keyType, (Object)keyType)).getMethodHandle();
        MethodHandle keyHashcodeFunction = functionRegistry.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)keyType)).getMethodHandle();
        MethodHandle valueEqualsFunction = functionRegistry.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)valueType, (Object)valueType)).getMethodHandle();
        MethodHandle method = METHOD_HANDLE.bindTo(keyEqualsFunction).bindTo(keyHashcodeFunction).bindTo(valueEqualsFunction).bindTo(keyType).bindTo(valueType);
        return FunctionRegistry.operatorInfo(OperatorType.NOT_EQUAL, RETURN_TYPE, (List<TypeSignature>)ImmutableList.of((Object)typeSignature, (Object)typeSignature), method, true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static Boolean notEqual(MethodHandle keyEqualsFunction, MethodHandle keyHashcodeFunction, MethodHandle valueEqualsFunction, Type keyType, Type valueType, Block left, Block right) {
        Boolean equals = MapEqualOperator.equals(keyEqualsFunction, keyHashcodeFunction, valueEqualsFunction, keyType, valueType, left, right);
        if (equals == null) {
            return null;
        }
        return equals == false;
    }
}

