/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class MapHashCodeOperator
extends ParametricOperator {
    public static final MapHashCodeOperator MAP_HASH_CODE = new MapHashCodeOperator();
    private static final TypeSignature RETURN_TYPE = TypeSignature.parseTypeSignature((String)"bigint");
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapHashCodeOperator.class, "hash", MethodHandle.class, MethodHandle.class, Type.class, Type.class, Block.class);

    private MapHashCodeOperator() {
        super(OperatorType.HASH_CODE, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.comparableTypeParameter("V")), "bigint", (List<String>)ImmutableList.of((Object)"map<K,V>"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Type type = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
        TypeSignature typeSignature = type.getTypeSignature();
        MethodHandle keyHashCodeFunction = functionRegistry.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)keyType)).getMethodHandle();
        MethodHandle valueHashCodeFunction = functionRegistry.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)valueType)).getMethodHandle();
        MethodHandle method = METHOD_HANDLE.bindTo(keyHashCodeFunction).bindTo(valueHashCodeFunction).bindTo(keyType).bindTo(valueType);
        return FunctionRegistry.operatorInfo(OperatorType.HASH_CODE, RETURN_TYPE, (List<TypeSignature>)ImmutableList.of((Object)typeSignature), method, false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static long hash(MethodHandle keyHashCodeFunction, MethodHandle valueHashCodeFunction, Type keyType, Type valueType, Block block) {
        long result = 0L;
        for (int position = 0; position < block.getPositionCount(); position += 2) {
            result += TypeUtils.hashPosition(keyHashCodeFunction, keyType, block, position);
            result += TypeUtils.hashPosition(valueHashCodeFunction, valueType, block, position + 1);
        }
        return result;
    }
}

