/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class MapCardinalityFunction
extends ParametricScalar {
    public static final MapCardinalityFunction MAP_CARDINALITY = new MapCardinalityFunction();
    private static final Signature SIGNATURE = new Signature("cardinality", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "bigint", (List<String>)ImmutableList.of((Object)"map<K,V>"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapCardinalityFunction.class, "mapCardinality", Block.class);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Cardinality expects only one argument");
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        return new FunctionInfo(new Signature("cardinality", TypeSignature.parseTypeSignature((String)"bigint"), TypeUtils.parameterizedTypeName("map", keyType.getTypeSignature(), valueType.getTypeSignature())), "Returns the cardinality (size) of the map", this.isHidden(), METHOD_HANDLE, this.isDeterministic(), false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static long mapCardinality(Block block) {
        return block.getPositionCount() / 2;
    }
}

