/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;

public class JsonPathTokenizer
extends AbstractIterator<String> {
    private static final char QUOTE = '\"';
    private static final char DOT = '.';
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final char UNICODE_CARET = '\u2038';
    private final String path;
    private int index;

    public JsonPathTokenizer(String path) {
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path is null");
        if (path.isEmpty()) {
            throw this.invalidJsonPath();
        }
        this.match('$');
    }

    protected String computeNext() {
        if (!this.hasNextCharacter()) {
            return (String)this.endOfData();
        }
        if (this.tryMatch('.')) {
            return this.matchPathSegment();
        }
        if (this.tryMatch('[')) {
            String token = this.tryMatch('\"') ? this.matchQuotedSubscript() : this.matchUnquotedSubscript();
            this.match(']');
            return token;
        }
        throw this.invalidJsonPath();
    }

    private String matchPathSegment() {
        int start = this.index;
        while (this.hasNextCharacter() && JsonPathTokenizer.isUnquotedPathCharacter(this.peekCharacter())) {
            this.nextCharacter();
        }
        int end = this.index;
        String token = this.path.substring(start, end);
        if (token.isEmpty()) {
            throw this.invalidJsonPath();
        }
        return token;
    }

    private static boolean isUnquotedPathCharacter(char c) {
        return c == ':' || JsonPathTokenizer.isUnquotedSubscriptCharacter(c);
    }

    private String matchUnquotedSubscript() {
        int start = this.index;
        while (this.hasNextCharacter() && JsonPathTokenizer.isUnquotedSubscriptCharacter(this.peekCharacter())) {
            this.nextCharacter();
        }
        int end = this.index;
        String token = this.path.substring(start, end);
        if (token.isEmpty()) {
            throw this.invalidJsonPath();
        }
        return token;
    }

    private static boolean isUnquotedSubscriptCharacter(char c) {
        return c == '_' || Character.isLetterOrDigit(c);
    }

    private String matchQuotedSubscript() {
        int start = this.index;
        while (this.hasNextCharacter() && this.peekCharacter() != '\"') {
            this.nextCharacter();
        }
        int end = this.index;
        String token = this.path.substring(start, end);
        this.match('\"');
        return token;
    }

    private boolean hasNextCharacter() {
        return this.index < this.path.length();
    }

    private void match(char expected) {
        if (!this.tryMatch(expected)) {
            throw this.invalidJsonPath();
        }
    }

    private boolean tryMatch(char expected) {
        if (this.peekCharacter() != expected) {
            return false;
        }
        ++this.index;
        return true;
    }

    private void nextCharacter() {
        ++this.index;
    }

    private char peekCharacter() {
        return this.path.charAt(this.index);
    }

    private PrestoException invalidJsonPath() {
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid JSON path: '%s'", this.path));
    }

    public String toString() {
        return this.path.substring(0, this.index) + '\u2038' + this.path.substring(this.index);
    }
}

