/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArraySubscriptOperator
extends ParametricOperator {
    public static final ArraySubscriptOperator ARRAY_SUBSCRIPT = new ArraySubscriptOperator();
    private static final MethodHandle METHOD_HANDLE_UNKNOWN = Reflection.methodHandle(ArraySubscriptOperator.class, "arrayWithUnknownType", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArraySubscriptOperator.class, "booleanSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArraySubscriptOperator.class, "longSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArraySubscriptOperator.class, "doubleSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArraySubscriptOperator.class, "sliceSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArraySubscriptOperator.class, "objectSubscript", Type.class, Block.class, Long.TYPE);

    protected ArraySubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "E", (List<String>)ImmutableList.of((Object)"array<E>", (Object)"bigint"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (String)"Expected one type, got %s", (Object[])new Object[]{types});
        Type elementType = types.get("E");
        MethodHandle methodHandle = elementType.getJavaType() == Void.TYPE ? METHOD_HANDLE_UNKNOWN : (elementType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (elementType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (elementType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (elementType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT))));
        methodHandle = methodHandle.bindTo(elementType);
        Preconditions.checkNotNull((Object)methodHandle, (Object)"methodHandle is null");
        return new FunctionInfo(Signature.internalOperator(OperatorType.SUBSCRIPT.name(), elementType.getTypeSignature(), TypeUtils.parameterizedTypeName("array", elementType.getTypeSignature()), TypeSignature.parseTypeSignature((String)"bigint")), "Array subscript", true, methodHandle, true, true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static void arrayWithUnknownType(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
    }

    public static Long longSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Ints.checkedCast((long)(index - 1L));
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getLong(array, position);
    }

    public static Boolean booleanSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Ints.checkedCast((long)(index - 1L));
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getBoolean(array, position);
    }

    public static Double doubleSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Ints.checkedCast((long)(index - 1L));
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getDouble(array, position);
    }

    public static Slice sliceSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Ints.checkedCast((long)(index - 1L));
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getSlice(array, position);
    }

    public static Object objectSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Ints.checkedCast((long)(index - 1L));
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getObject(array, position);
    }

    public static void checkArrayIndex(long index) {
        if (index == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (index < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript is negative");
        }
    }

    public static void checkIndex(Block array, long index) {
        ArraySubscriptOperator.checkArrayIndex(index);
        if (index > (long)array.getPositionCount()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript out of bounds");
        }
    }
}

