/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ArraySortFunction
extends ParametricScalar {
    public static final ArraySortFunction ARRAY_SORT_FUNCTION = new ArraySortFunction();
    private static final String FUNCTION_NAME = "array_sort";
    private static final Signature SIGNATURE = new Signature("array_sort", (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"array<E>"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArraySortFunction.class, "sort", Type.class, Block.class);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Sorts the given array in ascending order according to the natural ordering of its elements.";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)String.format("%s expects only one argument", FUNCTION_NAME));
        Type type = types.get("E");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(type);
        Signature signature = new Signature(FUNCTION_NAME, TypeUtils.parameterizedTypeName("array", type.getTypeSignature()), TypeUtils.parameterizedTypeName("array", type.getTypeSignature()));
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Block sort(final Type type, final Block block) {
        List positions = Ints.asList((int[])new int[block.getPositionCount()]);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            positions.set(i, i);
        }
        Collections.sort(positions, new Comparator<Integer>(){

            @Override
            public int compare(Integer p1, Integer p2) {
                return type.compareTo(block, p1.intValue(), block, p2.intValue());
            }
        });
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), block.getPositionCount());
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            type.appendTo(block, position, blockBuilder);
        }
        return blockBuilder.build();
    }
}

