/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.ArrayEqualOperator;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayNotEqualOperator
extends ParametricOperator {
    public static final ArrayNotEqualOperator ARRAY_NOT_EQUAL = new ArrayNotEqualOperator();
    private static final TypeSignature RETURN_TYPE = TypeSignature.parseTypeSignature((String)"boolean");
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayNotEqualOperator.class, "notEqual", MethodHandle.class, Type.class, Block.class, Block.class);

    private ArrayNotEqualOperator() {
        super(OperatorType.NOT_EQUAL, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), "boolean", (List<String>)ImmutableList.of((Object)"array<T>", (Object)"array<T>"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type elementType = types.get("T");
        Type type = typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)elementType.getTypeSignature()), (List)ImmutableList.of());
        TypeSignature typeSignature = type.getTypeSignature();
        MethodHandle equalsFunction = functionRegistry.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)elementType, (Object)elementType)).getMethodHandle();
        MethodHandle method = METHOD_HANDLE.bindTo(equalsFunction).bindTo(elementType);
        return FunctionRegistry.operatorInfo(OperatorType.NOT_EQUAL, RETURN_TYPE, (List<TypeSignature>)ImmutableList.of((Object)typeSignature, (Object)typeSignature), method, false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static boolean notEqual(MethodHandle equalsFunction, Type type, Block left, Block right) {
        return !ArrayEqualOperator.equals(equalsFunction, type, left, right);
    }
}

