/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArrayJoin
extends ParametricScalar {
    public static final ArrayJoin ARRAY_JOIN = new ArrayJoin();
    public static final ArrayJoinWithNullReplacement ARRAY_JOIN_WITH_NULL_REPLACEMENT = new ArrayJoinWithNullReplacement();
    private static final TypeSignature VARCHAR_TYPE_SIGNATURE = VarcharType.VARCHAR.getTypeSignature();
    private static final String FUNCTION_NAME = "array_join";
    private static final String DESCRIPTION = "Concatenates the elements of the given array using a delimiter and an optional string to replace nulls";
    private static final Signature SIGNATURE = new Signature("array_join", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("T")), "varchar", (List<String>)ImmutableList.of((Object)"array<T>", (Object)"varchar"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayJoin.class, "arrayJoin", FunctionInfo.class, Type.class, ConnectorSession.class, Block.class, Slice.class);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("T");
        TypeSignature arrayType = TypeUtils.parameterizedTypeName("array", type.getTypeSignature());
        Signature signature = new Signature(FUNCTION_NAME, VARCHAR_TYPE_SIGNATURE, arrayType, VARCHAR_TYPE_SIGNATURE);
        return ArrayJoin.specializeArrayJoin(types, functionRegistry, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), signature, METHOD_HANDLE);
    }

    private static FunctionInfo specializeArrayJoin(Map<String, Type> types, FunctionRegistry functionRegistry, List<Boolean> nullableArguments, Signature signature, MethodHandle methodHandle) {
        Type type = types.get("T");
        FunctionInfo castFunction = functionRegistry.getExactFunction(Signature.internalOperator(OperatorType.CAST.name(), VARCHAR_TYPE_SIGNATURE, (List<TypeSignature>)ImmutableList.of((Object)type.getTypeSignature())));
        if (!(type instanceof UnknownType)) {
            Failures.checkCondition(castFunction != null, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Input type %s not supported", type);
        }
        return new FunctionInfo(signature, DESCRIPTION, false, methodHandle.bindTo(castFunction).bindTo(type), true, false, nullableArguments);
    }

    public static Slice arrayJoin(FunctionInfo castFunction, Type elementType, ConnectorSession session, Block arrayBlock, Slice delimiter) {
        return ArrayJoin.arrayJoin(castFunction, elementType, session, arrayBlock, delimiter, null);
    }

    public static Slice arrayJoin(FunctionInfo castFunction, Type elementType, ConnectorSession session, Block arrayBlock, Slice delimiter, Slice nullReplacement) {
        int numElements = arrayBlock.getPositionCount();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(arrayBlock.getSizeInBytes() + delimiter.length() * arrayBlock.getPositionCount());
        Class javaType = elementType.getJavaType();
        Class<?>[] parameters = null;
        MethodHandle castFunctionHandle = null;
        if (castFunction != null) {
            parameters = castFunction.getMethodHandle().type().parameterArray();
            castFunctionHandle = castFunction.getMethodHandle();
        }
        for (int i = 0; i < numElements; ++i) {
            if (arrayBlock.isNull(i)) {
                if (nullReplacement == null) continue;
                sliceOutput.appendBytes(nullReplacement);
            } else if (javaType == Boolean.TYPE) {
                sliceOutput.appendBytes(ArrayJoin.invokeCast(parameters, castFunctionHandle, session, elementType.getBoolean(arrayBlock, i)));
            } else if (javaType == Double.TYPE) {
                sliceOutput.appendBytes(ArrayJoin.invokeCast(parameters, castFunctionHandle, session, elementType.getDouble(arrayBlock, i)));
            } else if (javaType == Long.TYPE) {
                sliceOutput.appendBytes(ArrayJoin.invokeCast(parameters, castFunctionHandle, session, elementType.getLong(arrayBlock, i)));
            } else if (javaType == Slice.class) {
                sliceOutput.appendBytes(ArrayJoin.invokeCast(parameters, castFunctionHandle, session, elementType.getSlice(arrayBlock, i)));
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unexpected type %s", javaType.getName()));
            }
            if (i == numElements - 1) continue;
            sliceOutput.appendBytes(delimiter);
        }
        return sliceOutput.slice();
    }

    private static Slice invokeCast(Class<?>[] castFunctionParameters, MethodHandle castFunctionHandle, ConnectorSession session, Object arg) {
        Slice slice;
        try {
            slice = castFunctionParameters[0] == ConnectorSession.class ? (Slice)castFunctionHandle.invokeWithArguments(session, arg) : (Slice)castFunctionHandle.invokeWithArguments(arg);
        }
        catch (Throwable throwable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, String.format("Error casting array element %s to VARCHAR", arg));
        }
        return slice;
    }

    public static class ArrayJoinWithNullReplacement
    extends ParametricScalar {
        private static final Signature SIGNATURE = new Signature("array_join", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("T")), "varchar", (List<String>)ImmutableList.of((Object)"array<T>", (Object)"varchar", (Object)"varchar"), false, false);
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayJoin.class, "arrayJoin", FunctionInfo.class, Type.class, ConnectorSession.class, Block.class, Slice.class, Slice.class);

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isDeterministic() {
            return true;
        }

        @Override
        public String getDescription() {
            return ArrayJoin.DESCRIPTION;
        }

        @Override
        public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            Type type = types.get("T");
            TypeSignature arrayType = TypeUtils.parameterizedTypeName("array", type.getTypeSignature());
            Signature signature = new Signature(ArrayJoin.FUNCTION_NAME, VARCHAR_TYPE_SIGNATURE, arrayType, VARCHAR_TYPE_SIGNATURE, VARCHAR_TYPE_SIGNATURE);
            return ArrayJoin.specializeArrayJoin(types, functionRegistry, (List)ImmutableList.of((Object)false, (Object)false, (Object)false), signature, ArrayJoinWithNullReplacement.METHOD_HANDLE);
        }
    }
}

