/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayGreaterThanOperator
extends ParametricOperator {
    public static final ArrayGreaterThanOperator ARRAY_GREATER_THAN = new ArrayGreaterThanOperator();
    private static final TypeSignature RETURN_TYPE = TypeSignature.parseTypeSignature((String)"boolean");
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayGreaterThanOperator.class, "greaterThan", MethodHandle.class, Type.class, Block.class, Block.class);

    private ArrayGreaterThanOperator() {
        super(OperatorType.GREATER_THAN, (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("T")), "boolean", (List<String>)ImmutableList.of((Object)"array<T>", (Object)"array<T>"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type elementType = types.get("T");
        Type type = typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)elementType.getTypeSignature()), (List)ImmutableList.of());
        TypeSignature typeSignature = type.getTypeSignature();
        MethodHandle greaterThanFunction = functionRegistry.resolveOperator(OperatorType.GREATER_THAN, (List<? extends Type>)ImmutableList.of((Object)elementType, (Object)elementType)).getMethodHandle();
        MethodHandle method = METHOD_HANDLE.bindTo(greaterThanFunction).bindTo(elementType);
        return FunctionRegistry.operatorInfo(OperatorType.GREATER_THAN, RETURN_TYPE, (List<TypeSignature>)ImmutableList.of((Object)typeSignature, (Object)typeSignature), method, false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static boolean greaterThan(MethodHandle greaterThanFunction, Type type, Block leftArray, Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = TypeUtils.castValue(type, leftArray, index);
            Object rightElement = TypeUtils.castValue(type, rightArray, index);
            try {
                if (greaterThanFunction.invoke(leftElement, rightElement)) {
                    return true;
                }
                if (!greaterThanFunction.invoke(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return leftArray.getPositionCount() > rightArray.getPositionCount();
    }
}

