/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.SimpleTypedSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArrayDistinctFunction
extends ParametricScalar {
    public static final ArrayDistinctFunction ARRAY_DISTINCT_FUNCTION = new ArrayDistinctFunction();
    private static final String FUNCTION_NAME = "array_distinct";
    private static final Signature SIGNATURE = new Signature("array_distinct", (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"array<E>"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayDistinctFunction.class, "distinct", Type.class, Block.class);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Remove duplicate values from the given array";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)String.format("%s expects only one argument", FUNCTION_NAME));
        Type type = types.get("E");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(type);
        Signature signature = new Signature(FUNCTION_NAME, TypeUtils.parameterizedTypeName("array", type.getTypeSignature()), TypeUtils.parameterizedTypeName("array", type.getTypeSignature()));
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Block distinct(Type type, Block array) {
        if (array.getPositionCount() == 0) {
            return array;
        }
        SimpleTypedSet typedSet = new SimpleTypedSet(type, array.getPositionCount());
        BlockBuilder distinctElementBlockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), array.getPositionCount());
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (typedSet.contains(array, i)) continue;
            typedSet.add(array, i);
            type.appendTo(array, i, distinctElementBlockBuilder);
        }
        return distinctElementBlockBuilder.build();
    }
}

