/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArrayContains
extends ParametricScalar {
    public static final ArrayContains ARRAY_CONTAINS = new ArrayContains();
    private static final TypeSignature RETURN_TYPE = TypeSignature.parseTypeSignature((String)"boolean");
    private static final String FUNCTION_NAME = "contains";
    private static final Signature SIGNATURE = new Signature("contains", (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), "boolean", (List<String>)ImmutableList.of((Object)"array<T>", (Object)"T"), false, false);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Determines whether given value exists in the array";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("T");
        TypeSignature valueType = type.getTypeSignature();
        TypeSignature arrayType = TypeUtils.parameterizedTypeName("array", valueType);
        MethodHandle methodHandle = type.getJavaType().isPrimitive() ? Reflection.methodHandle(ArrayContains.class, FUNCTION_NAME, Type.class, Block.class, type.getJavaType()) : Reflection.methodHandle(ArrayContains.class, FUNCTION_NAME, Type.class, Block.class, Object.class);
        Signature signature = new Signature(FUNCTION_NAME, RETURN_TYPE, arrayType, valueType);
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), methodHandle.bindTo(type), this.isDeterministic(), true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static Boolean contains(Type type, Block arrayBlock, Object value) {
        Block valueBlock = TypeUtils.createBlock(type, value);
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
            }
            if (!type.equalTo(arrayBlock, i, valueBlock, 0)) continue;
            return true;
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    public static Boolean contains(Type type, Block arrayBlock, long value) {
        Block valueBlock = TypeUtils.createBlock(type, value);
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
            }
            if (!type.equalTo(arrayBlock, i, valueBlock, 0)) continue;
            return true;
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    public static Boolean contains(Type type, Block arrayBlock, boolean value) {
        Block valueBlock = TypeUtils.createBlock(type, value);
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
            }
            if (!type.equalTo(arrayBlock, i, valueBlock, 0)) continue;
            return true;
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    public static Boolean contains(Type type, Block arrayBlock, double value) {
        Block valueBlock = TypeUtils.createBlock(type, value);
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
            }
            if (!type.equalTo(arrayBlock, i, valueBlock, 0)) continue;
            return true;
        }
        if (foundNull) {
            return null;
        }
        return false;
    }
}

