/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ArrayConstructor
extends ParametricScalar {
    public static final ArrayConstructor ARRAY_CONSTRUCTOR = new ArrayConstructor();
    private static final Signature SIGNATURE = new Signature("array_constructor", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"E", (Object)"E"), true, true);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        MethodHandle methodHandle;
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)"Can only construct arrays from exactly matching types");
        ImmutableList.Builder builder = ImmutableList.builder();
        Type type = types.get("E");
        for (int i = 0; i < arity; ++i) {
            if (type.getJavaType().isPrimitive()) {
                builder.add((Object)Primitives.wrap((Class)type.getJavaType()));
                continue;
            }
            builder.add((Object)type.getJavaType());
        }
        ImmutableList stackTypes = builder.build();
        Class<?> clazz = ArrayConstructor.generateArrayConstructor(stackTypes, type);
        try {
            Method method = clazz.getMethod("arrayConstructor", (Class[])stackTypes.toArray((Object[])new Class[stackTypes.size()]));
            methodHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableList nullableParameters = ImmutableList.copyOf(Collections.nCopies(stackTypes.size(), true));
        return new FunctionInfo(Signatures.arrayConstructorSignature(TypeUtils.parameterizedTypeName("array", type.getTypeSignature()), Collections.nCopies(arity, type.getTypeSignature())), "Constructs an array of the given elements", true, methodHandle, true, false, (List<Boolean>)nullableParameters);
    }

    private static Class<?> generateArrayConstructor(List<Class<?>> stackTypes, Type elementType) {
        List stackTypeNames = (List)stackTypes.stream().map(Class::getSimpleName).collect(ImmutableCollectors.toImmutableList());
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(Joiner.on((String)"").join((Iterable)stackTypeNames) + "ArrayConstructor"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a(Access.PRIVATE));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < stackTypes.size(); ++i) {
            Class<?> stackType = stackTypes.get(i);
            parameters.add((Object)Parameter.arg("arg" + i, stackType));
        }
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC, Access.STATIC), "arrayConstructor", ParameterizedType.type(Block.class), (Iterable<Parameter>)parameters.build());
        Scope scope = method.getScope();
        com.facebook.presto.byteCode.Block body = method.getBody();
        Variable elementTypeVariable = scope.declareVariable(Type.class, "elementTypeVariable");
        CallSiteBinder binder = new CallSiteBinder();
        body.comment("elementTypeVariable = elementType;").append(SqlTypeByteCodeExpression.constantType(binder, elementType)).putVariable(elementTypeVariable);
        Variable valuesVariable = scope.declareVariable(List.class, "values");
        body.comment("List<Object> values = new ArrayList();").newObject(ArrayList.class).dup().invokeConstructor(ArrayList.class, new Class[0]).putVariable(valuesVariable);
        for (int i = 0; i < stackTypes.size(); ++i) {
            body.comment("values.add(arg%d);", i).getVariable(valuesVariable).append(scope.getVariable("arg" + i));
            Class<?> stackType = stackTypes.get(i);
            if (stackType.isPrimitive()) {
                body.append(ByteCodeUtils.boxPrimitiveIfNecessary(scope, stackType));
            }
            body.invokeInterface(List.class, "add", Boolean.TYPE, Object.class);
        }
        body.comment("return toStackRepresentation(values, elementType);").getVariable(valuesVariable).getVariable(elementTypeVariable).invokeStatic(ArrayType.class, "toStackRepresentation", Block.class, List.class, Type.class).retObject();
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), new DynamicClassLoader(ArrayConstructor.class.getClassLoader()));
    }
}

