/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Preconditions;
import io.airlift.concurrent.MoreFutures;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class UpdateRequest {
    private final Block[] blocks;
    private final CompletableFuture<IndexSnapshot> indexSnapshotFuture = new CompletableFuture();
    private final Page page;

    public UpdateRequest(Block ... blocks) {
        this.blocks = (Block[])Preconditions.checkNotNull((Object)blocks, (Object)"blocks is null");
        this.page = new Page(blocks);
    }

    @Deprecated
    public Block[] getBlocks() {
        return this.blocks;
    }

    public Page getPage() {
        return this.page;
    }

    public void finished(IndexSnapshot indexSnapshot) {
        Preconditions.checkNotNull((Object)indexSnapshot, (Object)"indexSnapshot is null");
        Preconditions.checkState((boolean)this.indexSnapshotFuture.complete(indexSnapshot), (Object)"Already finished!");
    }

    public void failed(Throwable throwable) {
        this.indexSnapshotFuture.completeExceptionally(throwable);
    }

    public boolean isFinished() {
        return this.indexSnapshotFuture.isDone();
    }

    public IndexSnapshot getFinishedIndexSnapshot() {
        Preconditions.checkState((boolean)this.indexSnapshotFuture.isDone(), (Object)"Update request is not finished");
        return (IndexSnapshot)MoreFutures.getFutureValue(this.indexSnapshotFuture);
    }
}

