/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class MaxOrMinByStateSerializer
implements AccumulatorStateSerializer<MaxOrMinByState> {
    private final Type valueType;
    private final Type keyType;

    public MaxOrMinByStateSerializer(Type valueType, Type keyType) {
        this.valueType = valueType;
        this.keyType = keyType;
    }

    @Override
    public Type getSerializedType() {
        return VarcharType.VARCHAR;
    }

    @Override
    public void serialize(MaxOrMinByState state, BlockBuilder out) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput((int)state.getEstimatedSize());
        int keyLength = 0;
        if (state.getKey() != null && !state.getKey().isNull(0)) {
            keyLength = state.getKey().getLength(0);
        }
        sliceOutput.writeInt(keyLength);
        int valueLength = 0;
        if (state.getValue() != null && !state.getValue().isNull(0)) {
            valueLength = state.getValue().getLength(0);
        }
        sliceOutput.writeInt(valueLength);
        if (state.getKey() != null && !state.getKey().isNull(0)) {
            MaxOrMinByStateSerializer.appendTo(this.keyType, (SliceOutput)sliceOutput, state.getKey());
        }
        if (state.getValue() != null && !state.getValue().isNull(0)) {
            MaxOrMinByStateSerializer.appendTo(this.valueType, (SliceOutput)sliceOutput, state.getValue());
        }
        Slice slice = sliceOutput.slice();
        out.writeBytes(slice, 0, slice.length());
        out.closeEntry();
    }

    private static void appendTo(Type type, SliceOutput output, Block block) {
        if (type.getJavaType() == Long.TYPE) {
            output.appendLong(type.getLong(block, 0));
        } else if (type.getJavaType() == Double.TYPE) {
            output.appendDouble(type.getDouble(block, 0));
        } else if (type.getJavaType() == Slice.class) {
            output.appendBytes(type.getSlice(block, 0));
        } else if (type.getJavaType() == Boolean.TYPE) {
            output.appendByte(type.getBoolean(block, 0) ? 1 : 0);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type.getJavaType().getSimpleName());
        }
    }

    @Override
    public void deserialize(Block block, int index, MaxOrMinByState state) {
        BasicSliceInput input = block.getSlice(index, 0, block.getLength(index)).getInput();
        int keyLength = input.readInt();
        int valueLength = input.readInt();
        state.setKey(null);
        state.setValue(null);
        if (keyLength > 0) {
            state.setKey(MaxOrMinByStateSerializer.toBlock(this.keyType, (SliceInput)input, keyLength));
        }
        if (valueLength > 0) {
            state.setValue(MaxOrMinByStateSerializer.toBlock(this.valueType, (SliceInput)input, valueLength));
        }
    }

    private static Block toBlock(Type type, SliceInput input, int length) {
        BlockBuilder builder = type.createBlockBuilder(new BlockBuilderStatus(), 1, length);
        if (type.getJavaType() == Long.TYPE) {
            type.writeLong(builder, input.readLong());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(builder, input.readDouble());
        } else if (type.getJavaType() == Slice.class) {
            type.writeSlice(builder, input.readSlice(length));
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(builder, input.readByte() != 0);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type.getJavaType().getSimpleName());
        }
        return builder.build();
    }
}

