/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.ArbitraryAggregationState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.BlockBigArray;

public class ArbitraryAggregationStateFactory
implements AccumulatorStateFactory<ArbitraryAggregationState> {
    private final Type valueType;

    public ArbitraryAggregationStateFactory(Type valueType) {
        this.valueType = valueType;
    }

    @Override
    public ArbitraryAggregationState createSingleState() {
        return new SingleArbitraryAggregationState(this.valueType);
    }

    @Override
    public Class<? extends ArbitraryAggregationState> getSingleStateClass() {
        return SingleArbitraryAggregationState.class;
    }

    @Override
    public ArbitraryAggregationState createGroupedState() {
        return new GroupedArbitraryAggregationState(this.valueType);
    }

    @Override
    public Class<? extends ArbitraryAggregationState> getGroupedStateClass() {
        return GroupedArbitraryAggregationState.class;
    }

    public static class SingleArbitraryAggregationState
    implements ArbitraryAggregationState {
        private final Type valueType;
        private Block value;

        public SingleArbitraryAggregationState(Type valueType) {
            this.valueType = valueType;
        }

        @Override
        public long getEstimatedSize() {
            if (this.value != null) {
                return this.value.getRetainedSizeInBytes();
            }
            return 0L;
        }

        @Override
        public Type getType() {
            return this.valueType;
        }

        @Override
        public Block getValue() {
            return this.value;
        }

        @Override
        public void setValue(Block value) {
            this.value = value;
        }
    }

    public static class GroupedArbitraryAggregationState
    extends AbstractGroupedAccumulatorState
    implements ArbitraryAggregationState {
        private final Type valueType;
        private final BlockBigArray values = new BlockBigArray();

        public GroupedArbitraryAggregationState(Type valueType) {
            this.valueType = valueType;
        }

        @Override
        public void ensureCapacity(long size) {
            this.values.ensureCapacity(size);
        }

        @Override
        public long getEstimatedSize() {
            return this.values.sizeOf();
        }

        @Override
        public Type getType() {
            return this.valueType;
        }

        @Override
        public Block getValue() {
            return this.values.get(this.getGroupId());
        }

        @Override
        public void setValue(Block value) {
            this.values.set(this.getGroupId(), value);
        }
    }
}

