/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricAggregation;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByState;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByStateFactory;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class MaxBy
extends ParametricAggregation {
    public static final MaxBy MAX_BY = new MaxBy();
    private static final String NAME = "max_by";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MaxBy.class, "output", Type.class, MaxOrMinByState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MaxBy.class, "input", Type.class, MaxOrMinByState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MaxBy.class, "combine", Type.class, MaxOrMinByState.class, MaxOrMinByState.class);
    private static final Signature SIGNATURE = new Signature("max_by", (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("K"), (Object)Signature.typeParameter("V")), "V", (List<String>)ImmutableList.of((Object)"V", (Object)"K"), false, false);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public String getDescription() {
        return "Returns the value of the first argument, associated with the maximum value of the second argument";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Signature signature = new Signature(NAME, valueType.getTypeSignature(), valueType.getTypeSignature(), keyType.getTypeSignature());
        InternalAggregationFunction aggregation = MaxBy.generateAggregation(valueType, keyType);
        return new FunctionInfo(signature, this.getDescription(), aggregation);
    }

    private static InternalAggregationFunction generateAggregation(Type valueType, Type keyType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MaxBy.class.getClassLoader());
        MaxOrMinByStateSerializer stateSerializer = new MaxOrMinByStateSerializer(valueType, keyType);
        Type intermediateType = stateSerializer.getSerializedType();
        ImmutableList inputTypes = ImmutableList.of((Object)valueType, (Object)keyType);
        MaxOrMinByStateFactory stateFactory = new MaxOrMinByStateFactory();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, valueType, (List<Type>)inputTypes), MaxBy.createInputParameterMetadata(valueType, keyType), INPUT_FUNCTION.bindTo(keyType), null, null, COMBINE_FUNCTION.bindTo(keyType), OUTPUT_FUNCTION.bindTo(valueType), MaxOrMinByState.class, stateSerializer, stateFactory, valueType, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, valueType, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value, Type key) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, key), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type keyType, MaxOrMinByState state, Block value, Block key, int position) {
        if (state.getKey() == null || state.getKey().isNull(0)) {
            state.setKey(key.getSingleValueBlock(position));
            state.setValue(value.getSingleValueBlock(position));
        } else if (keyType.compareTo(key, position, state.getKey(), 0) > 0) {
            state.setKey(key.getSingleValueBlock(position));
            state.setValue(value.getSingleValueBlock(position));
        }
    }

    public static void combine(Type keyType, MaxOrMinByState state, MaxOrMinByState otherState) {
        if (state.getKey() == null) {
            state.setKey(otherState.getKey());
            state.setValue(otherState.getValue());
        } else if (otherState.getKey() != null && keyType.compareTo(otherState.getKey(), 0, state.getKey(), 0) > 0) {
            state.setKey(otherState.getKey());
            state.setValue(otherState.getValue());
        }
    }

    public static void output(Type valueType, MaxOrMinByState state, BlockBuilder out) {
        if (state.getValue() == null) {
            out.appendNull();
        } else {
            valueType.appendTo(state.getValue(), 0, out);
        }
    }
}

