/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.SimpleTypedSet;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class KeyValuePairs {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(KeyValuePairs.class).instanceSize();
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    private final TypedSet keySet;
    private final BlockBuilder keyBlockBuilder;
    private final Type keyType;
    private final BlockBuilder valueBlockBuilder;
    private final Type valueType;

    public KeyValuePairs(Type keyType, Type valueType) {
        Preconditions.checkNotNull((Object)keyType, (Object)"keyType is null");
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
        this.keyType = keyType;
        this.valueType = valueType;
        this.keySet = new SimpleTypedSet(keyType, 10);
        this.keyBlockBuilder = this.keyType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(keyType, 16));
        this.valueBlockBuilder = this.valueType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(valueType, 16));
    }

    public KeyValuePairs(Block serialized, Type keyType, Type valueType) {
        this(keyType, valueType);
        Preconditions.checkNotNull((Object)serialized, (Object)"serialized is null");
        this.deserialize(serialized);
    }

    public Block getKeys() {
        return this.keyBlockBuilder.build();
    }

    public Block getValues() {
        return this.valueBlockBuilder.build();
    }

    private void deserialize(Block block) {
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            this.add(block, block, i, i + 1);
        }
    }

    public Block serialize() {
        Block values = this.valueBlockBuilder.build();
        Block keys = this.keyBlockBuilder.build();
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)this.keyType, (Object)this.valueType), new BlockBuilderStatus(), keys.getPositionCount() * 2);
        for (int i = 0; i < keys.getPositionCount(); ++i) {
            this.keyType.appendTo(keys, i, (BlockBuilder)blockBuilder);
            this.valueType.appendTo(values, i, (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }

    public long estimatedInMemorySize() {
        long size = INSTANCE_SIZE;
        size += (long)this.keyBlockBuilder.getRetainedSizeInBytes();
        size += (long)this.valueBlockBuilder.getRetainedSizeInBytes();
        return size += this.keySet.getEstimatedSize();
    }

    public void add(Block key, Block value, int keyPosition, int valuePosition) {
        if (!this.keySet.contains(key, keyPosition)) {
            this.keySet.add(key, keyPosition);
            this.keyType.appendTo(key, keyPosition, this.keyBlockBuilder);
            if (value.isNull(valuePosition)) {
                this.valueBlockBuilder.appendNull();
            } else {
                this.valueType.appendTo(value, valuePosition, this.valueBlockBuilder);
            }
        }
    }
}

