/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricAggregation;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.ArbitraryAggregationState;
import com.facebook.presto.operator.aggregation.state.ArbitraryAggregationStateFactory;
import com.facebook.presto.operator.aggregation.state.ArbitraryAggregationStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArbitraryAggregation
extends ParametricAggregation {
    public static final ArbitraryAggregation ARBITRARY_AGGREGATION = new ArbitraryAggregation();
    private static final String NAME = "arbitrary";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ArbitraryAggregation.class, "output", ArbitraryAggregationState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ArbitraryAggregation.class, "input", ArbitraryAggregationState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ArbitraryAggregation.class, "combine", ArbitraryAggregationState.class, ArbitraryAggregationState.class);
    private static final Signature SIGNATURE = new Signature("arbitrary", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("T")), "T", (List<String>)ImmutableList.of((Object)"T"), false, false);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public String getDescription() {
        return "return an arbitrary non-null input value";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type valueType = types.get("T");
        Signature signature = new Signature(NAME, valueType.getTypeSignature(), valueType.getTypeSignature());
        InternalAggregationFunction aggregation = ArbitraryAggregation.generateAggregation(valueType);
        return new FunctionInfo(signature, this.getDescription(), aggregation);
    }

    private static InternalAggregationFunction generateAggregation(Type valueType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(ArbitraryAggregation.class.getClassLoader());
        ArbitraryAggregationStateSerializer stateSerializer = new ArbitraryAggregationStateSerializer();
        Type intermediateType = stateSerializer.getSerializedType();
        ImmutableList inputTypes = ImmutableList.of((Object)valueType);
        ArbitraryAggregationStateFactory stateFactory = new ArbitraryAggregationStateFactory(valueType);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, valueType, (List<Type>)inputTypes), ArbitraryAggregation.createInputParameterMetadata(valueType), INPUT_FUNCTION, null, null, COMBINE_FUNCTION, OUTPUT_FUNCTION, ArbitraryAggregationState.class, stateSerializer, stateFactory, valueType, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, valueType, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(ArbitraryAggregationState state, Block value, int position) {
        if (state.getValue() == null) {
            state.setValue(value.getSingleValueBlock(position));
        }
    }

    public static void combine(ArbitraryAggregationState state, ArbitraryAggregationState otherState) {
        if (state.getValue() == null && otherState.getValue() != null) {
            state.setValue(otherState.getValue());
        }
    }

    public static void output(ArbitraryAggregationState state, BlockBuilder out) {
        if (state.getValue() == null) {
            out.appendNull();
        } else {
            state.getType().appendTo(state.getValue(), 0, out);
        }
    }
}

