/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.SampleWeight;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

@AggregationFunction(value="count", approximate=true)
public final class ApproximateCountAggregation {
    private ApproximateCountAggregation() {
    }

    @InputFunction
    public static void input(ApproximateCountState state, @SampleWeight long sampleWeight) {
        if (sampleWeight > 0L) {
            state.setSamples(state.getSamples() + 1L);
            state.setCount(state.getCount() + sampleWeight);
        }
    }

    @CombineFunction
    public static void combine(ApproximateCountState state, ApproximateCountState otherState) {
        state.setCount(state.getCount() + otherState.getCount());
        state.setSamples(state.getSamples() + otherState.getSamples());
    }

    @OutputFunction(value="varchar")
    public static void output(ApproximateCountState state, double confidence, BlockBuilder out) {
        Slice value = Slices.utf8Slice((String)ApproximateUtils.formatApproximateResult(state.getCount(), ApproximateUtils.countError(state.getSamples(), state.getCount()), confidence, true));
        VarcharType.VARCHAR.writeSlice(out, value);
    }

    public static interface ApproximateCountState
    extends AccumulatorState {
        public long getCount();

        public void setCount(long var1);

        public long getSamples();

        public void setSamples(long var1);
    }
}

