/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public class AccumulatorCompiler {
    public GenericAccumulatorFactoryBinder generateAccumulatorFactoryBinder(AggregationMetadata metadata, DynamicClassLoader classLoader) {
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new GenericAccumulatorFactoryBinder(metadata.getStateSerializer(), metadata.getStateFactory(), accumulatorClass, groupedAccumulatorClass, metadata.isApproximate());
    }

    private static <T> Class<? extends T> generateAccumulatorClass(Class<T> accumulatorInterface, AggregationMetadata metadata, DynamicClassLoader classLoader) {
        boolean grouped = accumulatorInterface == GroupedAccumulator.class;
        boolean approximate = metadata.isApproximate();
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(metadata.getName() + accumulatorInterface.getSimpleName()), ParameterizedType.type(Object.class), ParameterizedType.type(accumulatorInterface));
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        AccumulatorStateSerializer<?> stateSerializer = metadata.getStateSerializer();
        AccumulatorStateFactory<?> stateFactory = metadata.getStateFactory();
        FieldDefinition stateSerializerField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "stateSerializer", AccumulatorStateSerializer.class);
        FieldDefinition stateFactoryField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "stateFactory", AccumulatorStateFactory.class);
        FieldDefinition inputChannelsField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "inputChannels", ParameterizedType.type(List.class, Integer.class));
        FieldDefinition maskChannelField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "maskChannel", ParameterizedType.type(Optional.class, Integer.class));
        FieldDefinition sampleWeightChannelField = null;
        FieldDefinition confidenceField = null;
        if (approximate) {
            sampleWeightChannelField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "sampleWeightChannel", ParameterizedType.type(Optional.class, Integer.class));
            confidenceField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "confidence", Double.TYPE);
        }
        FieldDefinition stateField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "state", grouped ? stateFactory.getGroupedStateClass() : stateFactory.getSingleStateClass());
        AccumulatorCompiler.generateConstructor(definition, stateSerializerField, stateFactoryField, inputChannelsField, maskChannelField, sampleWeightChannelField, confidenceField, stateField, grouped);
        AccumulatorCompiler.generateAddInput(definition, stateField, inputChannelsField, maskChannelField, sampleWeightChannelField, metadata.getInputMetadata(), metadata.getInputFunction(), callSiteBinder, grouped);
        AccumulatorCompiler.generateGetEstimatedSize(definition, stateField);
        AccumulatorCompiler.generateGetIntermediateType(definition, callSiteBinder, stateSerializer.getSerializedType());
        AccumulatorCompiler.generateGetFinalType(definition, callSiteBinder, metadata.getOutputType());
        if (metadata.getIntermediateInputFunction() == null) {
            AccumulatorCompiler.generateAddIntermediateAsCombine(definition, stateField, stateSerializerField, stateFactoryField, metadata.getCombineFunction(), stateFactory.getSingleStateClass(), callSiteBinder, grouped);
        } else {
            AccumulatorCompiler.generateAddIntermediateAsIntermediateInput(definition, stateField, metadata.getIntermediateInputMetadata(), metadata.getIntermediateInputFunction(), callSiteBinder, grouped);
        }
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateIntermediate(definition, stateSerializerField, stateField);
        } else {
            AccumulatorCompiler.generateEvaluateIntermediate(definition, stateSerializerField, stateField);
        }
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateFinal(definition, confidenceField, stateField, metadata.getOutputFunction(), metadata.isApproximate(), callSiteBinder);
        } else {
            AccumulatorCompiler.generateEvaluateFinal(definition, confidenceField, stateField, metadata.getOutputFunction(), metadata.isApproximate(), callSiteBinder);
        }
        return CompilerUtils.defineClass(definition, accumulatorInterface, callSiteBinder.getBindings(), classLoader);
    }

    private static MethodDefinition generateGetIntermediateType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a(Access.PUBLIC), "getIntermediateType", ParameterizedType.type(Type.class), new Parameter[0]);
        methodDefinition.getBody().append(SqlTypeByteCodeExpression.constantType(callSiteBinder, type)).retObject();
        return methodDefinition;
    }

    private static MethodDefinition generateGetFinalType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a(Access.PUBLIC), "getFinalType", ParameterizedType.type(Type.class), new Parameter[0]);
        methodDefinition.getBody().append(SqlTypeByteCodeExpression.constantType(callSiteBinder, type)).retObject();
        return methodDefinition;
    }

    private static void generateGetEstimatedSize(ClassDefinition definition, FieldDefinition stateField) {
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        ByteCodeExpression state = method.getThis().getField(stateField);
        method.getBody().append(state.invoke("getEstimatedSize", Long.TYPE, new ByteCodeExpression[0]).ret());
    }

    private static void generateAddInput(ClassDefinition definition, FieldDefinition stateField, FieldDefinition inputChannelsField, FieldDefinition maskChannelField, @Nullable FieldDefinition sampleWeightChannelField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg("groupIdsBlock", GroupByIdBlock.class));
        }
        Parameter page = Parameter.arg("page", Page.class);
        parameters.add((Object)page);
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC), "addInput", ParameterizedType.type(Void.TYPE), (Iterable<Parameter>)parameters.build());
        Scope scope = method.getScope();
        com.facebook.presto.byteCode.Block body = method.getBody();
        Variable thisVariable = method.getThis();
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateField, body);
        }
        ArrayList<Variable> parameterVariables = new ArrayList<Variable>();
        for (int i = 0; i < AggregationMetadata.countInputChannels(parameterMetadatas); ++i) {
            parameterVariables.add(scope.declareVariable(Block.class, "block" + i));
        }
        Variable masksBlock = scope.declareVariable(Block.class, "masksBlock");
        Variable sampleWeightsBlock = null;
        if (sampleWeightChannelField != null) {
            sampleWeightsBlock = scope.declareVariable(Block.class, "sampleWeightsBlock");
        }
        body.comment("masksBlock = maskChannel.map(page.blockGetter()).orElse(null);").append(thisVariable.getField(maskChannelField)).append(page).invokeStatic(ParameterizedType.type(AggregationUtils.class), "pageBlockGetter", ParameterizedType.type(Function.class, Integer.class, Block.class), ParameterizedType.type(Page.class)).invokeVirtual(Optional.class, "map", Optional.class, Function.class).pushNull().invokeVirtual(Optional.class, "orElse", Object.class, Object.class).checkCast(Block.class).putVariable(masksBlock);
        if (sampleWeightChannelField != null) {
            body.comment("sampleWeightsBlock = sampleWeightChannel.map(page.blockGetter()).get();").append(thisVariable.getField(sampleWeightChannelField)).append(page).invokeStatic(ParameterizedType.type(AggregationUtils.class), "pageBlockGetter", ParameterizedType.type(Function.class, Integer.class, Block.class), ParameterizedType.type(Page.class)).invokeVirtual(Optional.class, "map", Optional.class, Function.class).invokeVirtual(Optional.class, "get", Object.class, new Class[0]).checkCast(Block.class).putVariable(sampleWeightsBlock);
        }
        for (int i = 0; i < AggregationMetadata.countInputChannels(parameterMetadatas); ++i) {
            body.comment("%s = page.getBlock(inputChannels.get(%d));", ((Variable)parameterVariables.get(i)).getName(), i).append(page).append(thisVariable.getField(inputChannelsField)).push(i).invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(Integer.class).invokeVirtual(Integer.class, "intValue", Integer.TYPE, new Class[0]).invokeVirtual(Page.class, "getBlock", Block.class, Integer.TYPE).putVariable((Variable)parameterVariables.get(i));
        }
        com.facebook.presto.byteCode.Block block = AccumulatorCompiler.generateInputForLoop(stateField, parameterMetadatas, inputFunction, scope, parameterVariables, masksBlock, sampleWeightsBlock, callSiteBinder, grouped);
        body.append(block);
        body.ret();
    }

    private static com.facebook.presto.byteCode.Block generateInputForLoop(FieldDefinition stateField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, Scope scope, List<Variable> parameterVariables, Variable masksBlock, @Nullable Variable sampleWeightsBlock, CallSiteBinder callSiteBinder, boolean grouped) {
        Variable page = scope.getVariable("page");
        Variable positionVariable = scope.declareVariable(Integer.TYPE, "position");
        Variable sampleWeightVariable = null;
        if (sampleWeightsBlock != null) {
            sampleWeightVariable = scope.declareVariable(Long.TYPE, "sampleWeight");
        }
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block().append(page).invokeVirtual(Page.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable).initializeVariable(positionVariable);
        if (sampleWeightVariable != null) {
            block.initializeVariable(sampleWeightVariable);
        }
        ByteCodeNode loopBody = AccumulatorCompiler.generateInvokeInputFunction(scope, stateField, positionVariable, sampleWeightVariable, parameterVariables, parameterMetadatas, inputFunction, callSiteBinder, grouped);
        ArrayList<Boolean> nullable = new ArrayList<Boolean>();
        for (AggregationMetadata.ParameterMetadata metadata : parameterMetadatas) {
            switch (metadata.getParameterType()) {
                case INPUT_CHANNEL: 
                case BLOCK_INPUT_CHANNEL: {
                    nullable.add(false);
                    break;
                }
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    nullable.add(true);
                    break;
                }
            }
        }
        Preconditions.checkState((nullable.size() == parameterVariables.size() ? 1 : 0) != 0, (Object)"Number of parameters does not match");
        for (int i = 0; i < parameterVariables.size(); ++i) {
            if (((Boolean)nullable.get(i)).booleanValue()) continue;
            Variable variableDefinition = parameterVariables.get(i);
            loopBody = new IfStatement("if(!%s.isNull(position))", variableDefinition.getName()).condition(new com.facebook.presto.byteCode.Block().getVariable(variableDefinition).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, Integer.TYPE)).ifFalse(loopBody);
        }
        loopBody = sampleWeightVariable != null ? AccumulatorCompiler.generateComputeSampleWeightAndCheckGreaterThanZero(loopBody, sampleWeightVariable, masksBlock, sampleWeightsBlock, positionVariable) : new IfStatement("if(testMask(%s, position))", masksBlock.getName()).condition(new com.facebook.presto.byteCode.Block().getVariable(masksBlock).getVariable(positionVariable).invokeStatic(CompilerOperations.class, "testMask", Boolean.TYPE, Block.class, Integer.TYPE)).ifTrue(loopBody);
        block.append(new ForLoop().initialize(new com.facebook.presto.byteCode.Block().putVariable(positionVariable, 0)).condition(new com.facebook.presto.byteCode.Block().getVariable(positionVariable).getVariable(rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new com.facebook.presto.byteCode.Block().incrementVariable(positionVariable, (byte)1)).body(loopBody));
        return block;
    }

    private static ByteCodeNode generateComputeSampleWeightAndCheckGreaterThanZero(ByteCodeNode body, Variable sampleWeight, Variable masks, Variable sampleWeights, Variable position) {
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block().comment("sampleWeight = computeSampleWeight(masks, sampleWeights, position);").getVariable(masks).getVariable(sampleWeights).getVariable(position).invokeStatic(ApproximateUtils.class, "computeSampleWeight", Long.TYPE, Block.class, Block.class, Integer.TYPE).putVariable(sampleWeight);
        block.append(new IfStatement("if(sampleWeight > 0)", new Object[0]).condition(new com.facebook.presto.byteCode.Block().getVariable(sampleWeight).invokeStatic(CompilerOperations.class, "longGreaterThanZero", Boolean.TYPE, Long.TYPE)).ifTrue(body).ifFalse(OpCode.NOP));
        return block;
    }

    private static com.facebook.presto.byteCode.Block generateInvokeInputFunction(Scope scope, FieldDefinition stateField, Variable position, @Nullable Variable sampleWeight, List<Variable> parameterVariables, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block();
        if (grouped) {
            AccumulatorCompiler.generateSetGroupIdFromGroupIdsBlock(scope, stateField, block);
        }
        block.comment("Call input function with unpacked Block arguments");
        Class<?>[] parameters = inputFunction.type().parameterArray();
        int inputChannel = 0;
        block7: for (int i = 0; i < parameters.length; ++i) {
            AggregationMetadata.ParameterMetadata parameterMetadata = parameterMetadatas.get(i);
            switch (parameterMetadata.getParameterType()) {
                case STATE: {
                    block.append(scope.getThis().getField(stateField));
                    continue block7;
                }
                case BLOCK_INDEX: {
                    block.getVariable(position);
                    continue block7;
                }
                case SAMPLE_WEIGHT: {
                    Preconditions.checkNotNull((Object)sampleWeight, (Object)"sampleWeight is null");
                    block.getVariable(sampleWeight);
                    continue block7;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    block.getVariable(parameterVariables.get(inputChannel));
                    ++inputChannel;
                    continue block7;
                }
                case INPUT_CHANNEL: {
                    com.facebook.presto.byteCode.Block getBlockByteCode = new com.facebook.presto.byteCode.Block().getVariable(parameterVariables.get(inputChannel));
                    AccumulatorCompiler.pushStackType(scope, block, parameterMetadata.getSqlType(), getBlockByteCode, parameters[i], callSiteBinder);
                    ++inputChannel;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter type: " + (Object)((Object)parameterMetadata.getParameterType()));
                }
            }
        }
        block.append(ByteCodeUtils.invoke(callSiteBinder.bind(inputFunction), "input"));
        return block;
    }

    private static void pushStackType(Scope scope, com.facebook.presto.byteCode.Block block, Type sqlType, com.facebook.presto.byteCode.Block getBlockByteCode, Class<?> parameter, CallSiteBinder callSiteBinder) {
        Variable position = scope.getVariable("position");
        if (parameter == Long.TYPE) {
            block.comment("%s.getLong(block, position)", sqlType.getTypeSignature()).append(SqlTypeByteCodeExpression.constantType(callSiteBinder, sqlType)).append(getBlockByteCode).append(position).invokeInterface(Type.class, "getLong", Long.TYPE, Block.class, Integer.TYPE);
        } else if (parameter == Double.TYPE) {
            block.comment("%s.getDouble(block, position)", sqlType.getTypeSignature()).append(SqlTypeByteCodeExpression.constantType(callSiteBinder, sqlType)).append(getBlockByteCode).append(position).invokeInterface(Type.class, "getDouble", Double.TYPE, Block.class, Integer.TYPE);
        } else if (parameter == Boolean.TYPE) {
            block.comment("%s.getBoolean(block, position)", sqlType.getTypeSignature()).append(SqlTypeByteCodeExpression.constantType(callSiteBinder, sqlType)).append(getBlockByteCode).append(position).invokeInterface(Type.class, "getBoolean", Boolean.TYPE, Block.class, Integer.TYPE);
        } else if (parameter == Slice.class) {
            block.comment("%s.getSlice(block, position)", sqlType.getTypeSignature()).append(SqlTypeByteCodeExpression.constantType(callSiteBinder, sqlType)).append(getBlockByteCode).append(position).invokeInterface(Type.class, "getSlice", Slice.class, Block.class, Integer.TYPE);
        } else {
            block.comment("%s.getObject(block, position)", sqlType.getTypeSignature()).append(SqlTypeByteCodeExpression.constantType(callSiteBinder, sqlType)).append(getBlockByteCode).append(position).invokeInterface(Type.class, "getObject", Object.class, Block.class, Integer.TYPE);
        }
    }

    private static void generateAddIntermediateAsCombine(ClassDefinition definition, FieldDefinition stateField, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, MethodHandle combineFunction, Class<?> singleStateClass, CallSiteBinder callSiteBinder, boolean grouped) {
        MethodDefinition method = AccumulatorCompiler.declareAddIntermediate(definition, grouped);
        Scope scope = method.getScope();
        com.facebook.presto.byteCode.Block body = method.getBody();
        Variable thisVariable = method.getThis();
        Variable block = scope.getVariable("block");
        Variable scratchState = scope.declareVariable(singleStateClass, "scratchState");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.comment("scratchState = stateFactory.createSingleState();").append(thisVariable.getField(stateFactoryField)).invokeInterface(AccumulatorStateFactory.class, "createSingleState", Object.class, new Class[0]).checkCast(scratchState.getType()).putVariable(scratchState);
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateField, body);
        }
        com.facebook.presto.byteCode.Block loopBody = new com.facebook.presto.byteCode.Block();
        if (grouped) {
            Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
            loopBody.append(thisVariable.getField(stateField).invoke("setGroupId", Void.TYPE, groupIdsBlock.invoke("getGroupId", Long.TYPE, position)));
        }
        loopBody.append(thisVariable.getField(stateSerializerField).invoke("deserialize", Void.TYPE, block, position, scratchState.cast(Object.class)));
        loopBody.comment("combine(state, scratchState)").append(thisVariable.getField(stateField)).append(scratchState).append(ByteCodeUtils.invoke(callSiteBinder.bind(combineFunction), "combine"));
        if (grouped) {
            IfStatement ifStatement = new IfStatement("if (!groupIdsBlock.isNull(position))", new Object[0]).condition(ByteCodeExpressions.not(scope.getVariable("groupIdsBlock").invoke("isNull", Boolean.TYPE, position))).ifTrue(loopBody);
            loopBody = new com.facebook.presto.byteCode.Block().append(ifStatement);
        }
        body.append(AccumulatorCompiler.generateBlockNonNullPositionForLoop(scope, position, loopBody)).ret();
    }

    private static void generateSetGroupIdFromGroupIdsBlock(Scope scope, FieldDefinition stateField, com.facebook.presto.byteCode.Block block) {
        Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
        Variable position = scope.getVariable("position");
        ByteCodeExpression state = scope.getThis().getField(stateField);
        block.append(state.invoke("setGroupId", Void.TYPE, groupIdsBlock.invoke("getGroupId", Long.TYPE, position)));
    }

    private static void generateEnsureCapacity(Scope scope, FieldDefinition stateField, com.facebook.presto.byteCode.Block block) {
        Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
        ByteCodeExpression state = scope.getThis().getField(stateField);
        block.append(state.invoke("ensureCapacity", Void.TYPE, groupIdsBlock.invoke("getGroupCount", Long.TYPE, new ByteCodeExpression[0])));
    }

    private static MethodDefinition declareAddIntermediate(ClassDefinition definition, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg("groupIdsBlock", GroupByIdBlock.class));
        }
        parameters.add((Object)Parameter.arg("block", Block.class));
        return definition.declareMethod(Access.a(Access.PUBLIC), "addIntermediate", ParameterizedType.type(Void.TYPE), (Iterable<Parameter>)parameters.build());
    }

    private static void generateAddIntermediateAsIntermediateInput(ClassDefinition definition, FieldDefinition stateField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle intermediateInputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        MethodDefinition method = AccumulatorCompiler.declareAddIntermediate(definition, grouped);
        Scope scope = method.getScope();
        com.facebook.presto.byteCode.Block body = method.getBody();
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateField, body);
        }
        Variable positionVariable = scope.declareVariable(Integer.TYPE, "position");
        com.facebook.presto.byteCode.Block loopBody = AccumulatorCompiler.generateInvokeInputFunction(scope, stateField, positionVariable, null, (List<Variable>)ImmutableList.of((Object)scope.getVariable("block")), parameterMetadatas, intermediateInputFunction, callSiteBinder, grouped);
        if (grouped) {
            IfStatement ifStatement = new IfStatement("if (!groupIdsBlock.isNull(position))", new Object[0]).condition(ByteCodeExpressions.not(scope.getVariable("groupIdsBlock").invoke("isNull", Boolean.TYPE, positionVariable))).ifTrue(loopBody);
            loopBody = new com.facebook.presto.byteCode.Block().append(ifStatement);
        }
        body.append(AccumulatorCompiler.generateBlockNonNullPositionForLoop(scope, positionVariable, loopBody)).ret();
    }

    private static com.facebook.presto.byteCode.Block generateBlockNonNullPositionForLoop(Scope scope, Variable positionVariable, com.facebook.presto.byteCode.Block loopBody) {
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        Variable blockVariable = scope.getVariable("block");
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block().append(blockVariable).invokeInterface(Block.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable);
        IfStatement ifStatement = new IfStatement("if(!block.isNull(position))", new Object[0]).condition(new com.facebook.presto.byteCode.Block().append(blockVariable).append(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, Integer.TYPE)).ifFalse(loopBody);
        block.append(new ForLoop().initialize(positionVariable.set(ByteCodeExpressions.constantInt(0))).condition(new com.facebook.presto.byteCode.Block().append(positionVariable).append(rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new com.facebook.presto.byteCode.Block().incrementVariable(positionVariable, (byte)1)).body(ifStatement));
        return block;
    }

    private static void generateGroupedEvaluateIntermediate(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateField) {
        Parameter groupId = Parameter.arg("groupId", Integer.TYPE);
        Parameter out = Parameter.arg("out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), groupId, out);
        Variable thisVariable = method.getThis();
        ByteCodeExpression state = thisVariable.getField(stateField);
        ByteCodeExpression stateSerializer = thisVariable.getField(stateSerializerField);
        method.getBody().append(state.invoke("setGroupId", Void.TYPE, groupId.cast(Long.TYPE))).append(stateSerializer.invoke("serialize", Void.TYPE, state.cast(Object.class), out)).ret();
    }

    private static void generateEvaluateIntermediate(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateField) {
        Parameter out = Parameter.arg("out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), out);
        Variable thisVariable = method.getThis();
        ByteCodeExpression stateSerializer = thisVariable.getField(stateSerializerField);
        ByteCodeExpression state = thisVariable.getField(stateField);
        method.getBody().append(stateSerializer.invoke("serialize", Void.TYPE, state.cast(Object.class), out)).ret();
    }

    private static void generateGroupedEvaluateFinal(ClassDefinition definition, FieldDefinition confidenceField, FieldDefinition stateField, MethodHandle outputFunction, boolean approximate, CallSiteBinder callSiteBinder) {
        Parameter groupId = Parameter.arg("groupId", Integer.TYPE);
        Parameter out = Parameter.arg("out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC), "evaluateFinal", ParameterizedType.type(Void.TYPE), groupId, out);
        com.facebook.presto.byteCode.Block body = method.getBody();
        Variable thisVariable = method.getThis();
        ByteCodeExpression state = thisVariable.getField(stateField);
        body.append(state.invoke("setGroupId", Void.TYPE, groupId.cast(Long.TYPE)));
        body.comment("output(state, out)");
        body.append(state);
        if (approximate) {
            Preconditions.checkNotNull((Object)confidenceField, (Object)"confidenceField is null");
            body.append(thisVariable.getField(confidenceField));
        }
        body.append(out);
        body.append(ByteCodeUtils.invoke(callSiteBinder.bind(outputFunction), "output"));
        body.ret();
    }

    private static void generateEvaluateFinal(ClassDefinition definition, FieldDefinition confidenceField, FieldDefinition stateField, MethodHandle outputFunction, boolean approximate, CallSiteBinder callSiteBinder) {
        Parameter out = Parameter.arg("out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC), "evaluateFinal", ParameterizedType.type(Void.TYPE), out);
        com.facebook.presto.byteCode.Block body = method.getBody();
        Variable thisVariable = method.getThis();
        ByteCodeExpression state = thisVariable.getField(stateField);
        body.comment("output(state, out)");
        body.append(state);
        if (approximate) {
            Preconditions.checkNotNull((Object)confidenceField, (Object)"confidenceField is null");
            body.append(thisVariable.getField(confidenceField));
        }
        body.append(out);
        body.append(ByteCodeUtils.invoke(callSiteBinder.bind(outputFunction), "output"));
        body.ret();
    }

    private static void generateConstructor(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, FieldDefinition inputChannelsField, FieldDefinition maskChannelField, @Nullable FieldDefinition sampleWeightChannelField, @Nullable FieldDefinition confidenceField, FieldDefinition stateField, boolean grouped) {
        Parameter stateSerializer = Parameter.arg("stateSerializer", AccumulatorStateSerializer.class);
        Parameter stateFactory = Parameter.arg("stateFactory", AccumulatorStateFactory.class);
        Parameter inputChannels = Parameter.arg("inputChannels", ParameterizedType.type(List.class, Integer.class));
        Parameter maskChannel = Parameter.arg("maskChannel", ParameterizedType.type(Optional.class, Integer.class));
        Parameter sampleWeightChannel = Parameter.arg("sampleWeightChannel", ParameterizedType.type(Optional.class, Integer.class));
        Parameter confidence = Parameter.arg("confidence", Double.TYPE);
        MethodDefinition method = definition.declareConstructor(Access.a(Access.PUBLIC), stateSerializer, stateFactory, inputChannels, maskChannel, sampleWeightChannel, confidence);
        com.facebook.presto.byteCode.Block body = method.getBody();
        Variable thisVariable = method.getThis();
        body.comment("super();").append(thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append(thisVariable.setField(stateSerializerField, AccumulatorCompiler.generateRequireNotNull(stateSerializer)));
        body.append(thisVariable.setField(stateFactoryField, AccumulatorCompiler.generateRequireNotNull(stateFactory)));
        body.append(thisVariable.setField(inputChannelsField, AccumulatorCompiler.generateRequireNotNull(inputChannels)));
        body.append(thisVariable.setField(maskChannelField, AccumulatorCompiler.generateRequireNotNull(maskChannel)));
        if (sampleWeightChannelField != null) {
            body.append(thisVariable.setField(sampleWeightChannelField, AccumulatorCompiler.generateRequireNotNull(sampleWeightChannel)));
        }
        String createState = grouped ? "createGroupedState" : "createSingleState";
        if (confidenceField != null) {
            body.append(thisVariable.setField(confidenceField, (ByteCodeExpression)confidence));
        }
        body.append(thisVariable.setField(stateField, stateFactory.invoke(createState, Object.class, new ByteCodeExpression[0]).cast(stateField.getType())));
        body.ret();
    }

    private static ByteCodeExpression generateRequireNotNull(Variable variable) {
        return ByteCodeExpressions.invokeStatic(Objects.class, "requireNonNull", Object.class, variable.cast(Object.class), ByteCodeExpressions.constantString(variable.getName() + " is null")).cast(variable.getType());
    }
}

