/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ArrayUnnester;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.MapUnnester;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Unnester;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnnestOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Integer> replicateChannels;
    private final List<Type> replicateTypes;
    private final List<Integer> unnestChannels;
    private final List<Type> unnestTypes;
    private final boolean withOrdinality;
    private final List<Type> outputTypes;
    private final PageBuilder pageBuilder;
    private final List<Unnester> unnesters;
    private boolean finishing;
    private Page currentPage;
    private int currentPosition;
    private int ordinalityCount;

    public UnnestOperator(OperatorContext operatorContext, List<Integer> replicateChannels, List<Type> replicateTypes, List<Integer> unnestChannels, List<Type> unnestTypes, boolean withOrdinality) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.replicateChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(replicateChannels, (Object)"replicateChannels is null")));
        this.replicateTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(replicateTypes, (Object)"replicateTypes is null")));
        this.unnestChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(unnestChannels, (Object)"unnestChannels is null")));
        this.unnestTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(unnestTypes, (Object)"unnestTypes is null")));
        this.withOrdinality = withOrdinality;
        Preconditions.checkArgument((replicateChannels.size() == replicateTypes.size() ? 1 : 0) != 0, (Object)"replicate channels or types has wrong size");
        Preconditions.checkArgument((unnestChannels.size() == unnestTypes.size() ? 1 : 0) != 0, (Object)"unnest channels or types has wrong size");
        ImmutableList.Builder outputTypesBuilder = ImmutableList.builder().addAll(replicateTypes).addAll(UnnestOperator.getUnnestedTypes(unnestTypes));
        if (withOrdinality) {
            outputTypesBuilder.add((Object)BigintType.BIGINT);
        }
        this.outputTypes = outputTypesBuilder.build();
        this.pageBuilder = new PageBuilder(this.outputTypes);
        this.unnesters = new ArrayList<Unnester>();
    }

    private static List<Type> getUnnestedTypes(List<Type> types) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : types) {
            Preconditions.checkArgument((type instanceof ArrayType || type instanceof MapType ? 1 : 0) != 0, (Object)"Can only unnest map and array types");
            builder.addAll((Iterable)type.getTypeParameters());
        }
        return builder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public final List<Type> getTypes() {
        return this.outputTypes;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty() && this.currentPage == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && !this.pageBuilder.isFull() && this.currentPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.currentPage == null ? 1 : 0) != 0, (Object)"currentPage is not null");
        Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Page buffer is full");
        this.currentPage = page;
        this.currentPosition = 0;
        this.initializeUnnesters();
    }

    private void initializeUnnesters() {
        this.unnesters.clear();
        for (int i = 0; i < this.unnestTypes.size(); ++i) {
            Type type = this.unnestTypes.get(i);
            int channel = this.unnestChannels.get(i);
            Block block = null;
            if (!this.currentPage.getBlock(channel).isNull(this.currentPosition)) {
                block = (Block)type.getObject(this.currentPage.getBlock(channel), this.currentPosition);
            }
            if (type instanceof ArrayType) {
                this.unnesters.add(new ArrayUnnester((ArrayType)type, block));
                continue;
            }
            if (type instanceof MapType) {
                this.unnesters.add(new MapUnnester((MapType)type, block));
                continue;
            }
            throw new IllegalArgumentException("Cannot unnest type: " + type);
        }
        this.ordinalityCount = 0;
    }

    private boolean anyUnnesterHasData() {
        for (Unnester unnester : this.unnesters) {
            if (!unnester.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Page getOutput() {
        while (!this.pageBuilder.isFull() && this.currentPage != null) {
            while (!this.anyUnnesterHasData()) {
                ++this.currentPosition;
                if (this.currentPosition == this.currentPage.getPositionCount()) {
                    this.currentPage = null;
                    this.currentPosition = 0;
                    break;
                }
                this.initializeUnnesters();
            }
            while (!this.pageBuilder.isFull() && this.anyUnnesterHasData()) {
                for (int replicateChannel = 0; replicateChannel < this.replicateTypes.size(); ++replicateChannel) {
                    Type type = this.replicateTypes.get(replicateChannel);
                    int channel = this.replicateChannels.get(replicateChannel);
                    type.appendTo(this.currentPage.getBlock(channel), this.currentPosition, this.pageBuilder.getBlockBuilder(replicateChannel));
                }
                int offset = this.replicateTypes.size();
                this.pageBuilder.declarePosition();
                for (Unnester unnester : this.unnesters) {
                    if (unnester.hasNext()) {
                        unnester.appendNext(this.pageBuilder, offset);
                    } else {
                        for (int unnesterChannelIndex = 0; unnesterChannelIndex < unnester.getChannelCount(); ++unnesterChannelIndex) {
                            this.pageBuilder.getBlockBuilder(offset + unnesterChannelIndex).appendNull();
                        }
                    }
                    offset += unnester.getChannelCount();
                }
                if (!this.withOrdinality) continue;
                ++this.ordinalityCount;
                BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(offset), (long)this.ordinalityCount);
            }
        }
        if (!this.finishing && !this.pageBuilder.isFull() || this.pageBuilder.isEmpty()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    public static class UnnestOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Integer> replicateChannels;
        private final List<Type> replicateTypes;
        private final List<Integer> unnestChannels;
        private final List<Type> unnestTypes;
        private final boolean withOrdinality;
        private boolean closed;
        private final ImmutableList<Type> types;

        public UnnestOperatorFactory(int operatorId, List<Integer> replicateChannels, List<Type> replicateTypes, List<Integer> unnestChannels, List<Type> unnestTypes, boolean withOrdinality) {
            this.operatorId = operatorId;
            this.replicateChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(replicateChannels, (Object)"replicateChannels is null")));
            this.replicateTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(replicateTypes, (Object)"replicateTypes is null")));
            Preconditions.checkArgument((replicateChannels.size() == replicateTypes.size() ? 1 : 0) != 0, (Object)"replicateChannels and replicateTypes do not match");
            this.unnestChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(unnestChannels, (Object)"unnestChannels is null")));
            this.unnestTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(unnestTypes, (Object)"unnestTypes is null")));
            Preconditions.checkArgument((unnestChannels.size() == unnestTypes.size() ? 1 : 0) != 0, (Object)"unnestChannels and unnestTypes do not match");
            this.withOrdinality = withOrdinality;
            ImmutableList.Builder typesBuilder = ImmutableList.builder().addAll(replicateTypes).addAll((Iterable)UnnestOperator.getUnnestedTypes(unnestTypes));
            if (withOrdinality) {
                typesBuilder.add((Object)BigintType.BIGINT);
            }
            this.types = typesBuilder.build();
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, UnnestOperator.class.getSimpleName());
            return new UnnestOperator(operatorContext, this.replicateChannels, this.replicateTypes, this.unnestChannels, this.unnestTypes, this.withOrdinality);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

