/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;

public class TableCommitOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private final OperatorContext operatorContext;
    private final TableCommitter tableCommitter;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean committed;
    private boolean closed;
    private final ImmutableList.Builder<Slice> fragmentBuilder = ImmutableList.builder();

    public TableCommitOperator(OperatorContext operatorContext, TableCommitter tableCommitter) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.tableCommitter = (TableCommitter)Preconditions.checkNotNull((Object)tableCommitter, (Object)"tableCommitter is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return TYPES;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object[])new Object[]{this.state});
        Block rowCountBlock = page.getBlock(0);
        Block fragmentBlock = page.getBlock(1);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!rowCountBlock.isNull(position)) {
                this.rowCount += BigintType.BIGINT.getLong(rowCountBlock, position);
            }
            if (fragmentBlock.isNull(position)) continue;
            this.fragmentBuilder.add((Object)VarbinaryType.VARBINARY.getSlice(fragmentBlock, position));
        }
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        this.tableCommitter.commitTable((Collection<Slice>)this.fragmentBuilder.build());
        this.committed = true;
        PageBuilder page = new PageBuilder(this.getTypes());
        page.declarePosition();
        BigintType.BIGINT.writeLong(page.getBlockBuilder(0), this.rowCount);
        return page.build();
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            if (!this.committed) {
                this.tableCommitter.rollbackTable();
            }
        }
    }

    public static interface TableCommitter {
        public void commitTable(Collection<Slice> var1);

        public void rollbackTable();
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableCommitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final TableCommitter tableCommitter;
        private boolean closed;

        public TableCommitOperatorFactory(int operatorId, TableCommitter tableCommitter) {
            this.operatorId = operatorId;
            this.tableCommitter = (TableCommitter)Preconditions.checkNotNull((Object)tableCommitter, (Object)"tableCommitter is null");
        }

        @Override
        public List<Type> getTypes() {
            return TYPES;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, TableCommitOperator.class.getSimpleName());
            return new TableCommitOperator(context, this.tableCommitter);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

