/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SharedLookupSource;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class SettableLookupSourceSupplier
implements LookupSourceSupplier {
    private final List<Type> types;
    private final SettableFuture<SharedLookupSource> lookupSourceFuture = SettableFuture.create();
    private final AtomicInteger referenceCount = new AtomicInteger(1);

    public SettableLookupSourceSupplier(List<Type> types) {
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public ListenableFuture<LookupSource> getLookupSource(OperatorContext operatorContext) {
        return Futures.transform(this.lookupSourceFuture, Futures::immediateFuture);
    }

    public void setLookupSource(SharedLookupSource lookupSource) {
        Preconditions.checkNotNull((Object)lookupSource, (Object)"lookupSource is null");
        boolean wasSet = this.lookupSourceFuture.set((Object)lookupSource);
        Preconditions.checkState((boolean)wasSet, (Object)"Lookup source already set");
    }

    @Override
    public void retain() {
        this.referenceCount.incrementAndGet();
    }

    @Override
    public void release() {
        if (this.referenceCount.decrementAndGet() == 0) {
            Futures.addCallback(this.lookupSourceFuture, (FutureCallback)new FutureCallback<SharedLookupSource>(){

                public void onSuccess(SharedLookupSource result) {
                    result.freeMemory();
                }

                public void onFailure(Throwable t) {
                }
            });
        }
    }
}

