/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.math3.random.RandomDataGenerator;

public class SampleOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private final RandomDataGenerator rand = new RandomDataGenerator();
    private final double sampleRatio;
    private final boolean rescaled;
    private final int sampleWeightChannel;
    private boolean finishing;
    private int position = -1;
    private Page page;

    public SampleOperator(OperatorContext operatorContext, double sampleRatio, boolean rescaled, List<Type> types) {
        Preconditions.checkArgument((sampleRatio > 0.0 ? 1 : 0) != 0, (Object)"sample ratio must be strictly positive");
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = ImmutableList.copyOf(types);
        this.pageBuilder = new PageBuilder(types);
        this.sampleWeightChannel = types.size() - 1;
        this.sampleRatio = sampleRatio;
        this.rescaled = rescaled;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public final void finish() {
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty() && this.page == null;
    }

    @Override
    public final boolean needsInput() {
        return !this.finishing && !this.pageBuilder.isFull() && this.page == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Page buffer is full");
        Preconditions.checkState((this.page == null ? 1 : 0) != 0, (Object)"previous page has not been completely processed");
        this.page = page;
        this.position = 0;
    }

    @Override
    public Page getOutput() {
        if (this.page != null) {
            while (this.position < this.page.getPositionCount() && !this.pageBuilder.isFull()) {
                long repeats = this.rand.nextPoisson(this.sampleRatio);
                if (this.rescaled && repeats > 0L) {
                    repeats *= this.rand.nextPoisson(1.0 / this.sampleRatio);
                }
                if (repeats > 0L) {
                    this.pageBuilder.declarePosition();
                    for (int channel = 0; channel < this.types.size() - 1; ++channel) {
                        Type type = this.types.get(channel);
                        type.appendTo(this.page.getBlock(channel), this.position, this.pageBuilder.getBlockBuilder(channel));
                    }
                    BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(this.sampleWeightChannel), repeats);
                }
                ++this.position;
            }
            if (this.position >= this.page.getPositionCount()) {
                this.page = null;
            }
        }
        if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty()) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }

    public static class SampleOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final double sampleRatio;
        private final boolean rescaled;
        private final List<Type> types;
        private boolean closed;

        public SampleOperatorFactory(int operatorId, double sampleRatio, boolean rescaled, List<Type> sourceTypes) {
            this.operatorId = operatorId;
            this.sampleRatio = sampleRatio;
            this.rescaled = rescaled;
            this.types = ImmutableList.builder().addAll((Iterable)Preconditions.checkNotNull(sourceTypes, (Object)"sourceTypes is null")).add((Object)BigintType.BIGINT).build();
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, SampleOperator.class.getSimpleName());
            return new SampleOperator(operatorContext, this.sampleRatio, this.rescaled, this.types);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

