/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.MarkDistinctHash;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class MarkDistinctOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final MarkDistinctHash markDistinctHash;
    private Page outputPage;
    private boolean finishing;

    public MarkDistinctOperator(OperatorContext operatorContext, List<Type> types, int[] markDistinctChannels, Optional<Integer> hashChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        Preconditions.checkNotNull(hashChannel, (Object)"hashChannel is null");
        ImmutableList.Builder distinctTypes = ImmutableList.builder();
        for (int channel : markDistinctChannels) {
            distinctTypes.add((Object)types.get(channel));
        }
        this.markDistinctHash = new MarkDistinctHash((List<Type>)distinctTypes.build(), markDistinctChannels, hashChannel);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPage == null;
    }

    @Override
    public boolean needsInput() {
        this.operatorContext.setMemoryReservation(this.markDistinctHash.getEstimatedSize());
        return !this.finishing && this.outputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.outputPage == null ? 1 : 0) != 0, (Object)"Operator still has pending output");
        this.operatorContext.setMemoryReservation(this.markDistinctHash.getEstimatedSize());
        Block markerBlock = this.markDistinctHash.markDistinctRows(page);
        Block[] sourceBlocks = page.getBlocks();
        Block[] outputBlocks = new Block[sourceBlocks.length + 1];
        System.arraycopy(sourceBlocks, 0, outputBlocks, 0, sourceBlocks.length);
        outputBlocks[sourceBlocks.length] = markerBlock;
        this.outputPage = new Page(outputBlocks);
    }

    @Override
    public Page getOutput() {
        Page result = this.outputPage;
        this.outputPage = null;
        return result;
    }

    public static class MarkDistinctOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final Optional<Integer> hashChannel;
        private final int[] markDistinctChannels;
        private final List<Type> types;
        private boolean closed;

        public MarkDistinctOperatorFactory(int operatorId, List<? extends Type> sourceTypes, Collection<Integer> markDistinctChannels, Optional<Integer> hashChannel) {
            this.operatorId = operatorId;
            Preconditions.checkNotNull(markDistinctChannels, (Object)"markDistinctChannels is null");
            Preconditions.checkArgument((!markDistinctChannels.isEmpty() ? 1 : 0) != 0, (Object)"markDistinctChannels is empty");
            this.markDistinctChannels = Ints.toArray(markDistinctChannels);
            this.hashChannel = (Optional)Preconditions.checkNotNull(hashChannel, (Object)"hashChannel is null");
            this.types = ImmutableList.builder().addAll(sourceTypes).add((Object)BooleanType.BOOLEAN).build();
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, MarkDistinctOperator.class.getSimpleName());
            return new MarkDistinctOperator(operatorContext, this.types, this.markDistinctChannels, this.hashChannel);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

