/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class InterpretedHashGenerator
implements HashGenerator {
    private final List<Type> hashChannelTypes;
    private final int[] hashChannels;

    public InterpretedHashGenerator(List<Type> hashChannelTypes, int[] hashChannels) {
        this.hashChannels = (int[])Preconditions.checkNotNull((Object)hashChannels, (Object)"hashChannels is null");
        this.hashChannelTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(hashChannelTypes, (Object)"hashChannelTypes is null")));
        Preconditions.checkArgument((hashChannelTypes.size() == hashChannels.length ? 1 : 0) != 0);
    }

    @Override
    public int hashPosition(int position, Page page) {
        Block[] blocks = page.getBlocks();
        int result = 0;
        for (int i = 0; i < this.hashChannels.length; ++i) {
            Type type = this.hashChannelTypes.get(i);
            result = (int)CombineHashFunction.getHash(result, TypeUtils.hashPosition(type, blocks[this.hashChannels[i]], position));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashChannelTypes", this.hashChannelTypes).add("hashChannels", (Object)this.hashChannels).toString();
    }
}

