/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import io.airlift.slice.XxHash64;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Arrays;

public final class InMemoryJoinHash
implements LookupSource {
    private final LongArrayList addresses;
    private final PagesHashStrategy pagesHashStrategy;
    private final int channelCount;
    private final int mask;
    private final int[] key;
    private final boolean[] keyVisited;
    private final int[] positionLinks;
    private final long size;

    public InMemoryJoinHash(LongArrayList addresses, PagesHashStrategy pagesHashStrategy) {
        this.addresses = (LongArrayList)Preconditions.checkNotNull((Object)addresses, (Object)"addresses is null");
        this.pagesHashStrategy = (PagesHashStrategy)Preconditions.checkNotNull((Object)pagesHashStrategy, (Object)"pagesHashStrategy is null");
        this.channelCount = pagesHashStrategy.getChannelCount();
        int hashSize = HashCommon.arraySize((int)addresses.size(), (float)0.75f);
        this.size = SizeOf.sizeOfIntArray((int)hashSize) + SizeOf.sizeOfBooleanArray((int)hashSize) + SizeOf.sizeOfIntArray((int)addresses.size());
        this.mask = hashSize - 1;
        this.key = new int[hashSize];
        this.keyVisited = new boolean[hashSize];
        Arrays.fill(this.key, -1);
        this.positionLinks = new int[addresses.size()];
        Arrays.fill(this.positionLinks, -1);
        int position = 0;
        while (position < addresses.size()) {
            int pos = InMemoryJoinHash.getHashPosition(this.hashPosition(position), this.mask);
            while (this.key[pos] != -1) {
                int currentKey = this.key[pos];
                if (this.positionEqualsPosition(currentKey, position)) {
                    this.positionLinks[position] = currentKey;
                    break;
                }
                pos = pos + 1 & this.mask;
            }
            this.key[pos] = position++;
        }
    }

    @Override
    public final int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.size;
    }

    @Override
    public long getJoinPosition(int position, Page page) {
        return this.getJoinPosition(position, page, this.pagesHashStrategy.hashRow(position, page.getBlocks()));
    }

    @Override
    public long getJoinPosition(int position, Page page, int rawHash) {
        int pos = InMemoryJoinHash.getHashPosition(rawHash, this.mask);
        while (this.key[pos] != -1) {
            if (this.positionEqualsCurrentRow(this.key[pos], position, page.getBlocks())) {
                this.keyVisited[pos] = true;
                return this.key[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return -1L;
    }

    @Override
    public final long getNextJoinPosition(long currentPosition) {
        return this.positionLinks[Ints.checkedCast((long)currentPosition)];
    }

    @Override
    public LongIterator getUnvisitedJoinPositions() {
        return new UnvisitedJoinPositionIterator();
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        long pageAddress = this.addresses.getLong(Ints.checkedCast((long)position));
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        this.pagesHashStrategy.appendTo(blockIndex, blockPosition, pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
    }

    private int hashPosition(int position) {
        long pageAddress = this.addresses.getLong(position);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.hashPosition(blockIndex, blockPosition);
    }

    private boolean positionEqualsCurrentRow(int leftPosition, int rightPosition, Block ... rightBlocks) {
        long pageAddress = this.addresses.getLong(leftPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.positionEqualsRow(blockIndex, blockPosition, rightPosition, rightBlocks);
    }

    private boolean positionEqualsPosition(int leftPosition, int rightPosition) {
        long leftPageAddress = this.addresses.getLong(leftPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        long rightPageAddress = this.addresses.getLong(rightPosition);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        return this.pagesHashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition);
    }

    private static int getHashPosition(int rawHash, int mask) {
        return (int)XxHash64.hash((long)rawHash) & mask;
    }

    public class UnvisitedJoinPositionIterator
    extends AbstractLongIterator {
        private int nextKeyId = 0;
        private long nextJoinPosition = -1L;

        private UnvisitedJoinPositionIterator() {
            this.findUnvisitedKeyId();
        }

        public long nextLong() {
            long result = this.nextJoinPosition;
            this.nextJoinPosition = InMemoryJoinHash.this.getNextJoinPosition(this.nextJoinPosition);
            if (this.nextJoinPosition < 0L) {
                ++this.nextKeyId;
                this.findUnvisitedKeyId();
            }
            return result;
        }

        public boolean hasNext() {
            return this.nextKeyId < InMemoryJoinHash.this.keyVisited.length;
        }

        private void findUnvisitedKeyId() {
            while (this.nextKeyId < InMemoryJoinHash.this.keyVisited.length && (InMemoryJoinHash.this.key[this.nextKeyId] == -1 || InMemoryJoinHash.this.keyVisited[this.nextKeyId])) {
                ++this.nextKeyId;
            }
            if (this.nextKeyId < InMemoryJoinHash.this.keyVisited.length) {
                this.nextJoinPosition = InMemoryJoinHash.this.key[this.nextKeyId];
            }
        }
    }
}

