/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.InMemoryExchange;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;

public class InMemoryExchangeSourceOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final InMemoryExchange exchange;
    private final int bufferIndex;

    public InMemoryExchangeSourceOperator(OperatorContext operatorContext, InMemoryExchange exchange, int bufferIndex) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.exchange = (InMemoryExchange)Preconditions.checkNotNull((Object)exchange, (Object)"exchange is null");
        Preconditions.checkArgument((bufferIndex < exchange.getBufferCount() ? 1 : 0) != 0);
        this.bufferIndex = bufferIndex;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.exchange.getTypes();
    }

    @Override
    public void finish() {
        this.exchange.finish();
    }

    @Override
    public boolean isFinished() {
        return this.exchange.isFinished(this.bufferIndex);
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.exchange.waitForReading(this.bufferIndex);
        if (blocked.isDone()) {
            return NOT_BLOCKED;
        }
        return blocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        Page page = this.exchange.removePage(this.bufferIndex);
        if (page != null) {
            this.operatorContext.recordGeneratedInput(page.getSizeInBytes(), page.getPositionCount());
        }
        return page;
    }

    @Override
    public void close() throws Exception {
        this.finish();
    }

    public static class InMemoryExchangeSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final InMemoryExchange inMemoryExchange;
        private final boolean broadcast;
        private int bufferIndex;
        private boolean closed;

        public static InMemoryExchangeSourceOperatorFactory createRandomDistribution(int operatorId, InMemoryExchange inMemoryExchange) {
            Objects.requireNonNull(inMemoryExchange, "inMemoryExchange is null");
            Preconditions.checkArgument((inMemoryExchange.getBufferCount() == 1 ? 1 : 0) != 0, (Object)"exchange must have only one buffer");
            return new InMemoryExchangeSourceOperatorFactory(operatorId, inMemoryExchange, false);
        }

        public static InMemoryExchangeSourceOperatorFactory createBroadcastDistribution(int operatorId, InMemoryExchange inMemoryExchange) {
            Objects.requireNonNull(inMemoryExchange, "inMemoryExchange is null");
            Preconditions.checkArgument((inMemoryExchange.getBufferCount() > 1 ? 1 : 0) != 0, (Object)"exchange must have more than one buffer");
            return new InMemoryExchangeSourceOperatorFactory(operatorId, inMemoryExchange, true);
        }

        private InMemoryExchangeSourceOperatorFactory(int operatorId, InMemoryExchange inMemoryExchange, boolean broadcast) {
            this.operatorId = operatorId;
            this.inMemoryExchange = Objects.requireNonNull(inMemoryExchange, "inMemoryExchange is null");
            Preconditions.checkArgument((this.bufferIndex < inMemoryExchange.getBufferCount() ? 1 : 0) != 0);
            this.broadcast = broadcast;
        }

        @Override
        public List<Type> getTypes() {
            return this.inMemoryExchange.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            Preconditions.checkState((this.bufferIndex < this.inMemoryExchange.getBufferCount() ? 1 : 0) != 0, (Object)"All operators already created");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, InMemoryExchangeSourceOperator.class.getSimpleName());
            InMemoryExchangeSourceOperator operator = new InMemoryExchangeSourceOperator(operatorContext, this.inMemoryExchange, this.bufferIndex);
            if (this.broadcast) {
                ++this.bufferIndex;
            }
            return operator;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

